/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sms.local.service.internal;

import cn.hutool.core.codec.Base64;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sms.local.config.MosSmsConfiguration;
import com.bizunited.nebula.common.service.sms.SmsServiceAdapter;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

@Service
@ConditionalOnProperty(prefix="sms", name={"supplier"}, havingValue="mos")
public class MosSmsServiceImpl
extends SmsServiceAdapter {
    private static final Logger log = LoggerFactory.getLogger(MosSmsServiceImpl.class);
    @Autowired(required=false)
    private MosSmsConfiguration mosSmsConfiguration;

    public static void main(String[] args) {
        try {
            String accessSecret = DigestUtils.md5DigestAsHex((byte[])"2LhI9zEV".getBytes(StandardCharsets.UTF_8));
            String authorization = Base64.encode((CharSequence)("zlflm@zlflm:" + accessSecret));
            System.out.println("accessSecret:      " + accessSecret);
            System.out.println("authorization:      " + authorization);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aliyunSendSms(JSONArray jsonArray, String templateId, SmsTypeEnums smsType) {
        Validate.notEmpty((Collection)jsonArray, (String)"\u624b\u673a\u53f7\u548c\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((jsonArray.size() <= 1000 ? 1 : 0) != 0, (String)"\u6279\u91cf\u53d1\u9001\u65f6,\u5355\u6b21\u4e0d\u80fd\u8d85\u8fc71000\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)templateId, (String)"\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)smsType, (String)"\u77ed\u4fe1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result result = new Result();
        HttpResponse httpResponse = null;
        String url = this.mosSmsConfiguration.getUrl() + "/api/v1.0.0/message/group/send";
        HashMap headMap = Maps.newHashMap();
        String contentType = "application/json";
        headMap.put("Content-Type", contentType);
        headMap.put("Accept", "application/json");
        String accessSecret = DigestUtils.md5DigestAsHex((byte[])this.mosSmsConfiguration.getAccessKeySecret().getBytes(StandardCharsets.UTF_8));
        headMap.put("Authorization", Base64.encode((CharSequence)(this.mosSmsConfiguration.getAccessKeyId() + ":" + accessSecret)));
        JSONObject reqJson = new JSONObject();
        reqJson.put("batchName", (Object)this.mosSmsConfiguration.getSignName());
        reqJson.put("msgType", (Object)"sms");
        reqJson.put("items", (Object)jsonArray);
        String json = reqJson.toJSONString();
        try {
            log.info("http|https post request information,targetMain is {},contentType is {},head is {},json is {}", new Object[]{url, contentType, JSON.toJSONString((Object)headMap), json});
            HttpRequest httpRequest = this.createRequest(url, json, Method.POST, headMap, contentType, 20, 120, null);
            httpResponse = httpRequest.execute();
            result.setCode(Integer.valueOf(httpResponse.getStatus()));
            result.setSuccess(CommonConstant.SC_OK_200.equals(result.getCode()));
            String jsonStr = httpResponse.body();
            result.setResult((Object)jsonStr);
            String message = "";
            if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
                JSONObject jsonObject = null;
                try {
                    jsonObject = JSONObject.parseObject((String)jsonStr);
                }
                catch (Exception e) {
                    Validate.isTrue((boolean)Boolean.FALSE, (String)("\u7384\u6b66\u77ed\u4fe1\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u4e0d\u662fJSON;" + jsonStr), (Object[])new Object[0]);
                }
                Validate.isTrue((boolean)jsonObject.containsKey((Object)"code"), (String)"\u7384\u6b66\u77ed\u4fe1\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u672a\u5305\u542b[code]\u5b57\u6bb5!", (Object[])new Object[0]);
                String code = jsonObject.getString("code");
                if (!Objects.equals("0", code)) {
                    Validate.isTrue((boolean)jsonObject.containsKey((Object)"msg"), (String)"\u7384\u6b66\u77ed\u4fe1\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u672a\u5305\u542b[msg]\u5b57\u6bb5!", (Object[])new Object[0]);
                    message = "\u7384\u6b66\u77ed\u4fe1\u5e73\u53f0\u63d0\u793a:" + jsonObject.getString("msg");
                    result.error500(message);
                }
            } else {
                message = "\u7384\u6b66\u77ed\u4fe1\u5e73\u53f0\u672a\u8fd4\u56de\u4efb\u4f55\u4fe1\u606f!";
                result.error500(message);
            }
            log.info("http|https post request return information {}", (Object)JSON.toJSONString((Object)result));
            Validate.isTrue((boolean)result.isSuccess(), (String)message, (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("http|https post request  error ,targetMain is {},head is {},body is {}", new Object[]{url, JSON.toJSONString((Object)headMap), json});
            log.error(e.getMessage(), (Throwable)e);
            result.error500(e.getMessage());
            log.error("http|https post request return information {}", (Object)JSON.toJSONString((Object)result));
            Validate.isTrue((boolean)Boolean.FALSE, (String)("\u7384\u6b66\u77ed\u4fe1\u5e73\u53f0\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage()), (Object[])new Object[0]);
        }
        finally {
            if (Objects.nonNull(httpResponse)) {
                httpResponse.close();
            }
        }
    }

    public HttpRequest createRequest(String url, String json, Method method, Map<String, String> headMap, String contentType, int connectionTimeout, int readTimeout, Map<String, Object> formMap) {
        String realUrl = url;
        if (Method.GET.equals((Object)method)) {
            if (!url.endsWith("?")) {
                realUrl = realUrl + "?";
            }
            realUrl = realUrl + json;
        }
        HttpRequest httpRequest = HttpUtil.createRequest((Method)method, (String)realUrl);
        httpRequest.setConnectionTimeout(connectionTimeout * 1000);
        httpRequest.setReadTimeout(readTimeout * 1000);
        if (!CollectionUtils.isEmpty(headMap)) {
            httpRequest.addHeaders(headMap);
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            httpRequest.contentType(contentType);
        }
        if (Method.POST.equals((Object)method)) {
            if ("application/json".equals(contentType)) {
                httpRequest.body(json);
            } else if (Objects.nonNull(formMap)) {
                httpRequest.form(formMap);
            }
        }
        return httpRequest;
    }

    public void sendSms(String phone, String templateId, String content, SmsTypeEnums smsType) {
        Validate.notNull((Object)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("to", (Object)phone);
        jsonObject.put("content", (Object)content);
        jsonArray.add((Object)jsonObject);
        this.aliyunSendSms(jsonArray, templateId, smsType);
    }

    public void sendSms(Map<String, String> phoneContentMap, String templateId, SmsTypeEnums smsType) {
        Validate.notEmpty(phoneContentMap, (String)"\u624b\u673a\u53f7\u548c\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        JSONArray jsonArray = new JSONArray();
        phoneContentMap.forEach((phone, content) -> {
            Validate.notNull((Object)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)content, (String)"\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("to", phone);
            jsonObject.put("content", content);
            jsonArray.add((Object)jsonObject);
        });
        this.aliyunSendSms(jsonArray, templateId, smsType);
    }
}

