package com.biz.crm.common.sms.local.service.internal;

import cn.hutool.core.codec.Base64;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sms.local.config.MosSmsConfiguration;
import com.biz.crm.common.sms.sdk.constant.SmsConstant;
import com.bizunited.nebula.common.service.sms.SmsServiceAdapter;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import com.google.common.collect.Maps;
import jodd.net.MimeTypes;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

/**
 * @author ning.zhang
 * @description 玄武云短信发送实现类
 * @date 2024/08/16
 */
@Slf4j
@Service
@ConditionalOnProperty(prefix = "sms", name = "supplier", havingValue = "mos")
public class MosSmsServiceImpl extends SmsServiceAdapter {

    @Autowired(required = false)
    private MosSmsConfiguration mosSmsConfiguration;

    public static void main(String[] args) {

        try {

            String accessSecret = DigestUtils.md5DigestAsHex("2LhI9zEV".getBytes(StandardCharsets.UTF_8));
            String authorization = Base64.encode("zlflm@zlflm" + ":" + accessSecret);

            System.out.println("accessSecret:      " + accessSecret);
            System.out.println("authorization:      " + authorization);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public void aliyunSendSms(JSONArray jsonArray, String templateId, SmsTypeEnums smsType) {
        Validate.notEmpty(jsonArray, "手机号和短信内容不能为空！");
        Validate.isTrue(jsonArray.size() <= 1000, "批量发送时,单次不能超过1000！");
        Validate.notNull(templateId, "模板ID不能为空！");
        Validate.notNull(smsType, "短信类型不能为空！");
        Result<String> result = new Result<String>();
        HttpResponse httpResponse = null;
        String url = mosSmsConfiguration.getUrl() + SmsConstant.MOS_URI_NAME;
        Map<String, String> headMap = Maps.newHashMap();
        String contentType = "application/json";
        headMap.put("Content-Type", contentType);
        headMap.put("Accept", "application/json");
        String accessSecret = DigestUtils.md5DigestAsHex(mosSmsConfiguration.getAccessKeySecret().getBytes(StandardCharsets.UTF_8));
        headMap.put("Authorization", Base64.encode(mosSmsConfiguration.getAccessKeyId() + ":" + accessSecret));
        JSONObject reqJson = new JSONObject();
        reqJson.put("batchName", mosSmsConfiguration.getSignName());
        reqJson.put("msgType", "sms");
        reqJson.put("items", jsonArray);
        String json = reqJson.toJSONString();
        try {
            log.info("http|https post request information,targetMain is {},contentType is {},head is {},json is {}",
                    url, contentType, JSON.toJSONString(headMap), json);
            HttpRequest httpRequest = createRequest(url, json, Method.POST,
                    headMap, contentType, 20, 120, null);
            httpResponse = httpRequest.execute();
            result.setCode(httpResponse.getStatus());
            result.setSuccess(CommonConstant.SC_OK_200.equals(result.getCode()));
            String jsonStr = httpResponse.body();
            result.setResult(jsonStr);
//            {
//                    "code": "0",
//                    "msg": "成功",
//                    "uuid": "5c812609-06ee-4294-adb7-66144a11e65e"
//            }
            String message = "";
            if (StringUtils.isNotEmpty(jsonStr)) {
                JSONObject jsonObject = null;
                try {
                    jsonObject = JSONObject.parseObject(jsonStr);
                } catch (Exception e) {
                    Validate.isTrue(Boolean.FALSE, "玄武短信平台返回信息不是JSON;" + jsonStr);
                }
                Validate.isTrue(jsonObject.containsKey("code"), "玄武短信平台返回信息未包含[code]字段!");
                String code = jsonObject.getString("code");
                if (!Objects.equals("0", code)) {
                    Validate.isTrue(jsonObject.containsKey("msg"), "玄武短信平台返回信息未包含[msg]字段!");
                    message = "玄武短信平台提示:" + jsonObject.getString("msg");
                    result.error500(message);
                }
            } else {
                message = "玄武短信平台未返回任何信息!";
                result.error500(message);
            }
            log.info("http|https post request return information {}", JSON.toJSONString(result));
            Validate.isTrue(result.isSuccess(), message);
        } catch (Exception e) {
            log.error("http|https post request  error ,targetMain is {},head is {},body is {}", url, JSON.toJSONString(headMap), json);
            log.error(e.getMessage(), e);
            result.error500(e.getMessage());
            log.error("http|https post request return information {}", JSON.toJSONString(result));
            Validate.isTrue(Boolean.FALSE, "玄武短信平台发送异常：" + e.getMessage());
        } finally {
            if (Objects.nonNull(httpResponse)) {
                httpResponse.close();
            }
        }
    }

    public HttpRequest createRequest(String url, String json, Method method,
                                     Map<String, String> headMap, String contentType,
                                     int connectionTimeout, int readTimeout, Map<String, Object> formMap) {
        String realUrl = url;
        if (Method.GET.equals(method)) {
            if (!url.endsWith("?")) {
                realUrl = realUrl + "?";
            }
            realUrl = realUrl + json;
        }
        HttpRequest httpRequest = HttpUtil.createRequest(method, realUrl);
        httpRequest.setConnectionTimeout(connectionTimeout * 1000);
        httpRequest.setReadTimeout(readTimeout * 1000);
        if (!CollectionUtils.isEmpty(headMap)) {
            httpRequest.addHeaders(headMap);
        }
        if (StringUtils.isNotBlank(contentType)) {
            httpRequest.contentType(contentType);
        }
        if (Method.POST.equals(method)) {
            if (MimeTypes.MIME_APPLICATION_JSON.equals(contentType)) {
                httpRequest.body(json);
            } else {
                if (Objects.nonNull(formMap)) {
                    httpRequest.form(formMap);
                }
            }
        }
        return httpRequest;
    }

    @Override
    public void sendSms(String phone, String templateId, String content, SmsTypeEnums smsType) {
        // content 内容为模板的参数,内容应该是List转换为JSON字符串,如["张三","13555555555"]这样的JSON字符串
        Validate.notNull(phone, "手机号不能为空！");
        Validate.notNull(content, "短信内容不能为空！");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("to", phone);
        jsonObject.put("content", content);
        jsonArray.add(jsonObject);
        this.aliyunSendSms(jsonArray, templateId, smsType);
    }

    @Override
    public void sendSms(Map<String, String> phoneContentMap, String templateId, SmsTypeEnums smsType) {
        // content 内容为模板的参数,内容应该是List转换为JSON字符串,如["张三","13555555555"]这样的JSON字符串
        Validate.notEmpty(phoneContentMap, "手机号和短信内容不能为空！");
        JSONArray jsonArray = new JSONArray();
        phoneContentMap.forEach((phone, content) -> {
            Validate.notNull(phone, "手机号不能为空！");
            Validate.notNull(content, "短信内容不能为空！");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("to", phone);
            jsonObject.put("content", content);
            jsonArray.add(jsonObject);
        });
        this.aliyunSendSms(jsonArray, templateId, smsType);
    }
}
