/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.taxpay.exception;

import com.alibaba.fastjson2.JSONObject;
import com.biz.crm.taxpay.model.TaxBaseResponse;

public class ServiceException
extends RuntimeException {
    private final int httpStatusCode;
    private final String responseBody;
    private Integer errorCode;
    private String errorMessage;

    public ServiceException(int httpStatusCode, String responseBody) {
        super(String.format("\u4e1a\u52a1\u51fa\u9519:[%d]%nhttpResponseBody[%.1024s]%n", httpStatusCode, responseBody));
        this.httpStatusCode = httpStatusCode;
        this.responseBody = responseBody;
        if (responseBody != null && !responseBody.isEmpty()) {
            TaxBaseResponse taxBaseResponse = (TaxBaseResponse)JSONObject.parseObject((String)responseBody, TaxBaseResponse.class);
            this.errorCode = taxBaseResponse.getCode();
            this.errorMessage = taxBaseResponse.getMessage();
        }
    }

    public ServiceException(String message) {
        super(message);
        this.httpStatusCode = 200;
        this.responseBody = null;
        this.errorCode = 500;
        this.errorMessage = message;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

