/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.taxpay.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.biz.crm.taxpay.core.Config;
import com.biz.crm.taxpay.core.cipher.Signer;
import com.biz.crm.taxpay.core.cipher.Validator;
import com.biz.crm.taxpay.exception.ServiceException;
import com.biz.crm.taxpay.model.TaxBaseCallBackResponse;
import com.biz.crm.taxpay.model.TaxBaseResponse;
import com.biz.crm.taxpay.model.TaxCashDetailRequest;
import com.biz.crm.taxpay.model.TaxCashRequest;
import com.biz.crm.taxpay.model.TaxCashResultResponse;
import com.biz.crm.taxpay.model.TaxCashStatAccountResponse;
import com.biz.crm.taxpay.model.TaxSignCallBackResponse;
import com.biz.crm.taxpay.model.TaxSignResponse;
import com.biz.crm.taxpay.service.TaxRaiseService;
import com.biz.crm.taxpay.uitil.HttpServletUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class TaxRaiseServiceImpl
implements TaxRaiseService {
    private static final String TAX_CASH_URL = "%s/tax/v1/biz/api/terminalSendRed";
    private static final String TAX_QUERY_SIGN_STATUS_URL = "%s/tax/v1/biz/api/verifyTerminalStatus";
    private static final String TAX_FIND_CASH_INFO_BY_CODE_URL = "%s/tax/v1/biz/api/findTerminalSendRecordByCode";
    private static final String TAX_CLEAN_SING_URL = "%s/tax/v1/biz/api/cleanTerminalSign";
    private static final String TAX_FIND_CASH_LIST_URL = "%s/tax/v1/biz/api/findCashDetailByConditions";
    private final Signer signer;
    private final Validator validator;
    private final String basePath;

    private TaxRaiseServiceImpl(Builder builder) {
        this.signer = builder.signer;
        this.basePath = builder.basePath;
        this.validator = builder.validator;
    }

    @Override
    public TaxBaseResponse taxCash(TaxCashRequest request) {
        Objects.requireNonNull(request);
        String realPath = String.format(TAX_CASH_URL, this.basePath);
        JSONObject data = new JSONObject();
        data.put("cashRecordNo", (Object)request.getCashRecordNo());
        data.put("terminalCode", (Object)request.getTerminalCode());
        data.put("amount", (Object)String.valueOf(request.getAmount()));
        Map<String, String> headMap = this.signer.createHeadMap(data);
        ArrayList details = new ArrayList();
        for (TaxCashDetailRequest detailRequest : request.getDetails()) {
            HashMap<String, String> poolMap = new HashMap<String, String>();
            poolMap.put("amount", String.valueOf(detailRequest.getAmount()));
            poolMap.put("poolAccountCode", detailRequest.getPoolAccountCode());
            details.add(poolMap);
        }
        data.put("details", details);
        data.put("notifyUrl", (Object)request.getNotifyUrl());
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)realPath).headerMap(headMap, true)).body(JSON.toJSONString((Object)data)).execute();
        this.validator.validate(execute.getStatus(), execute.body());
        return (TaxBaseResponse)JSONObject.parseObject((String)execute.body(), TaxBaseResponse.class);
    }

    @Override
    public TaxBaseResponse<TaxSignResponse> verifySign(String terminalCode) {
        Objects.requireNonNull(terminalCode);
        String realPath = String.format(TAX_QUERY_SIGN_STATUS_URL, this.basePath);
        JSONObject data = new JSONObject();
        data.put("terminalCode", (Object)terminalCode);
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)realPath).headerMap(this.signer.createHeadMap(data), true)).body(JSON.toJSONString((Object)data)).execute();
        this.validator.validate(execute.getStatus(), execute.body());
        return (TaxBaseResponse)JSONObject.parseObject((String)execute.body(), (TypeReference)new TypeReference<TaxBaseResponse<TaxSignResponse>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public TaxBaseResponse<TaxCashResultResponse> findCashResultByNo(String cashRecordNo) {
        Objects.requireNonNull(cashRecordNo);
        String realPath = String.format(TAX_FIND_CASH_INFO_BY_CODE_URL, this.basePath);
        JSONObject data = new JSONObject();
        data.put("cashRecordNo", (Object)cashRecordNo);
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)realPath).headerMap(this.signer.createHeadMap(data), true)).body(JSON.toJSONString((Object)data)).execute();
        this.validator.validate(execute.getStatus(), execute.body());
        return (TaxBaseResponse)JSONObject.parseObject((String)execute.body(), (TypeReference)new TypeReference<TaxBaseResponse<TaxCashResultResponse>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public TaxBaseResponse cleanSign(String terminalCode) {
        Objects.requireNonNull(terminalCode);
        String realPath = String.format(TAX_CLEAN_SING_URL, this.basePath);
        JSONObject data = new JSONObject();
        data.put("terminalCode", (Object)terminalCode);
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)realPath).headerMap(this.signer.createHeadMap(data), true)).body(JSON.toJSONString((Object)data)).execute();
        this.validator.validate(execute.getStatus(), execute.body());
        return (TaxBaseResponse)JSONObject.parseObject((String)execute.body(), TaxBaseResponse.class);
    }

    @Override
    public TaxCashResultResponse cashCallBack(HttpServletRequest request) {
        String sign;
        String requestBody = HttpServletUtil.getBodyString(request);
        Objects.requireNonNull(requestBody);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TaxBaseCallBackResponse callBackResponse = (TaxBaseCallBackResponse)JSONObject.parseObject((String)requestBody, (TypeReference)new TypeReference<TaxBaseCallBackResponse<TaxCashResultResponse>>(){}, (Feature[])new Feature[0]);
        Objects.requireNonNull(callBackResponse);
        TaxCashResultResponse cashData = (TaxCashResultResponse)callBackResponse.getData();
        Objects.requireNonNull(cashData);
        JSONObject body = new JSONObject();
        body.put("cashRecordNo", (Object)cashData.getCashRecordNo());
        body.put("terminalCode", (Object)cashData.getTerminalCode());
        body.put("amount", (Object)String.valueOf(cashData.getAmount()));
        body.put("cashStatus", (Object)cashData.getCashStatus());
        if (cashData.getPayDate() != null) {
            body.put("payDate", (Object)sdf.format(cashData.getPayDate()));
        }
        body.put("createTime", (Object)sdf.format(cashData.getCreateTime()));
        body.put("payeeName", (Object)cashData.getPayeeName());
        body.put("idCard", (Object)cashData.getIdCard());
        body.put("payeePhone", (Object)cashData.getPayeePhone());
        body.put("bankCardNo", (Object)cashData.getBankCardNo());
        if (cashData.getReason() != null && !"".equals(cashData.getReason())) {
            body.put("reason", (Object)cashData.getReason());
        }
        if ((sign = this.signer.callBackSign(body, callBackResponse.getTimestamp())) == null || !sign.equals(callBackResponse.getSign())) {
            throw new ServiceException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
        }
        return cashData;
    }

    @Override
    public TaxSignCallBackResponse signCallBack(HttpServletRequest request) {
        String requestBody = HttpServletUtil.getBodyString(request);
        Objects.requireNonNull(requestBody);
        TaxBaseCallBackResponse callBackResponse = (TaxBaseCallBackResponse)JSONObject.parseObject((String)requestBody, (TypeReference)new TypeReference<TaxBaseCallBackResponse<TaxSignCallBackResponse>>(){}, (Feature[])new Feature[0]);
        Objects.requireNonNull(callBackResponse);
        TaxSignCallBackResponse signData = (TaxSignCallBackResponse)callBackResponse.getData();
        Objects.requireNonNull(signData);
        JSONObject body = new JSONObject();
        body.put("terminalCode", (Object)signData.getTerminalCode());
        body.put("signStatus", (Object)signData.getSignStatus());
        body.put("signDesc", (Object)signData.getSignDesc());
        body.put("idCard", (Object)signData.getIdCard());
        body.put("phone", (Object)signData.getPhone());
        body.put("name", (Object)signData.getName());
        body.put("bankCardNo", (Object)signData.getBankCardNo());
        String sign = this.signer.callBackSign(body, callBackResponse.getTimestamp());
        if (sign == null || !sign.equals(callBackResponse.getSign())) {
            throw new ServiceException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
        }
        return signData;
    }

    @Override
    public TaxBaseResponse<List<TaxCashStatAccountResponse>> statCashAccount(String startDate, String endDate) {
        Objects.requireNonNull(startDate);
        Objects.requireNonNull(endDate);
        String realPath = String.format(TAX_FIND_CASH_LIST_URL, this.basePath);
        JSONObject data = new JSONObject();
        data.put("startDate", (Object)startDate);
        data.put("endDate", (Object)endDate);
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)realPath).headerMap(this.signer.createHeadMap(data), true)).body(JSON.toJSONString((Object)data)).execute();
        this.validator.validate(execute.getStatus(), execute.body());
        return (TaxBaseResponse)JSONObject.parseObject((String)execute.body(), (TypeReference)new TypeReference<TaxBaseResponse<List<TaxCashStatAccountResponse>>>(){}, (Feature[])new Feature[0]);
    }

    public static void main(String[] args) {
    }

    public static class Builder {
        private Signer signer;
        private Validator validator;
        private String basePath;

        public Builder config(Config config) {
            this.signer = config.createSigner();
            this.basePath = config.getBasePath();
            this.validator = config.createValidator();
            return this;
        }

        public TaxRaiseService build() {
            return new TaxRaiseServiceImpl(this);
        }
    }
}

