/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.taxpay.core.cipher;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.taxpay.core.cipher.Signer;
import com.biz.crm.taxpay.uitil.DigestUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TaxPaySigner
implements Signer {
    private final String cashAppid;
    private final String cashSecret;

    public TaxPaySigner(String cashAppid, String cashSecret) {
        this.cashAppid = Objects.requireNonNull(cashAppid);
        this.cashSecret = Objects.requireNonNull(cashSecret);
    }

    @Override
    public String callBackSign(JSONObject jsonObject, long timestamp) {
        Objects.requireNonNull(jsonObject);
        jsonObject.put("appid", (Object)this.cashAppid);
        jsonObject.put("secret", (Object)this.cashSecret);
        jsonObject.put("dateTime", (Object)timestamp);
        return DigestUtils.md5DigestAsHex(JSON.toJSONString((Object)jsonObject).getBytes());
    }

    private String sign(JSONObject jsonObject, long timestamp) {
        Objects.requireNonNull(jsonObject);
        JSONObject body = new JSONObject();
        body.put("data", (Object)jsonObject);
        body.put("appid", (Object)this.cashAppid);
        body.put("secret", (Object)this.cashSecret);
        body.put("dateTime", (Object)timestamp);
        return DigestUtils.md5DigestAsHex(JSON.toJSONString((Object)body).getBytes());
    }

    @Override
    public Map<String, String> createHeadMap(JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        long timestamp = new Date().getTime();
        map.put("appid", this.cashAppid);
        map.put("timestamp", String.valueOf(timestamp));
        map.put("sign", this.sign(jsonObject, timestamp));
        return map;
    }
}

