/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.taxpay.core;

import com.biz.crm.taxpay.core.Config;
import com.biz.crm.taxpay.core.cipher.Signer;
import com.biz.crm.taxpay.core.cipher.TaxPaySigner;
import com.biz.crm.taxpay.core.cipher.TaxPayValidator;
import com.biz.crm.taxpay.core.cipher.Validator;
import java.util.Objects;

public final class TaxAutoSignConfig
implements Config {
    protected final String cashAppid;
    protected final String cashSecret;
    protected final String basePath;

    @Override
    public Signer createSigner() {
        return new TaxPaySigner(this.cashAppid, this.cashSecret);
    }

    private TaxAutoSignConfig(Builder builder) {
        this.basePath = builder.basePath;
        this.cashAppid = builder.cashAppid;
        this.cashSecret = builder.cashSecret;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public Validator createValidator() {
        return new TaxPayValidator();
    }

    public static class Builder {
        protected String cashAppid;
        protected String cashSecret;
        protected String basePath;

        public Builder cashAppid(String cashAppid) {
            this.cashAppid = cashAppid;
            return this;
        }

        public Builder cashSecret(String cashSecret) {
            this.cashSecret = cashSecret;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public TaxAutoSignConfig build() {
            Builder providerBuilder = new Builder().cashAppid(Objects.requireNonNull(this.cashAppid)).cashSecret(Objects.requireNonNull(this.cashSecret)).basePath(Objects.requireNonNull(this.basePath));
            return new TaxAutoSignConfig(providerBuilder);
        }
    }
}

