package com.biz.crm.taxpay.core.cipher;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * 签名器
 */
public interface Signer {


    /**
     * 回调签名生成
     * @param jsonObject 签名信息
     * @param timestamp 时间戳  如：1746766844117
     * @return 签名结果
     */
    String callBackSign(JSONObject jsonObject, long timestamp);


    /***
     * 组装请求头信息
     * @param jsonObject 签名信息
     * @param timestamp 时间戳  如：1746766844117
     * @return 签名结果
     * @return
     */
    Map<String,String> createHeadMap(JSONObject jsonObject);

}
