package com.biz.crm.taxpay.core.enums;

/**
 * api接口定义枚举
 */
public enum ApiInfoEnum {
    TAX_CASH("F0001","税筹平台提现接口","%s/tax/v1/biz/api/terminalSendRed"),
    TAX_QUERY_SIGN_STATUS("F0002","查询提现者认证信息接口","%s/tax/v1/biz/api/verifyTerminalStatus"),
    TAX_FIND_CASH_INFO_BY_CODE("F0003","根据提现编码查询提现记录信息","%s/tax/v1/biz/api/findTerminalSendRecordByCode"),
    TAX_CLEAN_SING("F0004","清除提现者认证信息接口","%s/tax/v1/biz/api/cleanTerminalSign"),
    TAX_FIND_CASH_LIST("F0005","根据条件查询提现记录列表接口","%s/tax/v1/biz/api/findCashDetailByConditions"),
    TAX_CHECK_CASH_AMOUNT("F0006","根据用户编码统计用户提现金额接口","%s/tax/v1/biz/api/checkCashAmount"),
    TAX_GOV_RATE_CONFIG("F0007","查询税筹平台税率配置接口","%s/tax/v1/biz/api/findTaxGovRateConfig"),
    TAX_CASH_RECORD("F0008","同步打款记录到税筹平台接口(西凤)","%s/tax/v1/ext/api/terminalSendRedCord"),
    TAX_CASH_OPT_GET_VOUCHER("F0009","同步打款记录到税筹平台接口(西凤)","%s/tax/v1/ext/api/terminalSendRedCord"),
    TAX_SYNC_CONSUMER_CASH_RECORD("F0010","同步消费者提现打款数据到税筹","%s/v1/biz/thrid/api/consumerCashRecordSync"),
    ;
    private String code;

    private String desc;

    private String url;
     ApiInfoEnum(String code, String desc, String url) {
        this.code = code;
        this.desc = desc;
        this.url = url;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getUrl() {
        return url;
    }
}
