package com.biz.crm.taxpay.exception;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.taxpay.model.TaxBaseResponse;

/***
 * 接口请求http异常
 */
public class HttpRequestException extends RuntimeException{

    private final int httpStatusCode;
    private final String responseBody;
    private Integer errorCode;
    private String errorMessage;

    /**
     * 返回状态码小于200或大于300调用
     * @param httpStatusCode http状态码
     * @param responseBody http返回体
     */
    public HttpRequestException(int httpStatusCode, String responseBody) {
        super(
                String.format(
                        "请求出错:[%d]%nhttpResponseBody[%.1024s]%n",
                        httpStatusCode, responseBody));
        this.httpStatusCode = httpStatusCode;
        this.responseBody = responseBody;
        if (responseBody != null && !responseBody.isEmpty()) {
            TaxBaseResponse taxBaseResponse = JSONObject.parseObject(responseBody, TaxBaseResponse.class);
            this.errorCode = taxBaseResponse.getCode();
            this.errorMessage = taxBaseResponse.getMessage();
        }
    }

    public int getHttpStatusCode() {
        return httpStatusCode;
    }

    public String getResponseBody() {
        return responseBody;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
