package com.biz.crm.taxpay.model;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 税筹提现记录详细信息
 */
public class TaxCashResultResponse {
    /**
     *  提现单号
     */
    private String cashRecordNo;
    /**
     * 终端编码
     */
    private  String terminalCode;

    /**
     * 金额
     * 说明：单位(分)
     */
    private BigDecimal amount;

    /***
     * 打款状态
     * 说明  1-已打款
     *      2-未打款
     *      3-打款中
     *      4-打款失败
     */
    private String cashStatus;

    /**
     * 打款时间
     */
    @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date payDate;

    /**
     * 提现时间
     */
    @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 收款人姓名
     */
    private String payeeName;

    /**
     * 手机号
     */
    private String payeePhone;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 银行卡号
     */
    private String bankCardNo;
    /**
     * 身份证号
     */
    private String idCard;
    /**
     * 姓名
     */
    private String personName;


    //银卡打款成功到账日期
    private String bankPayDate;
    //打款平台
    private String payPlatForm;
    //打款公司
    private String payCompany;

    //打款凭证名称,多个用，隔开
    private String payFileName;
    //打款凭证下载地址,多个用，隔开
    private String payFileUrl;


    /***
     * 打款失败原因
     */
    private String reason;

    public String getCashRecordNo() {
        return cashRecordNo;
    }

    public void setCashRecordNo(String cashRecordNo) {
        this.cashRecordNo = cashRecordNo;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCashStatus() {
        return cashStatus;
    }

    public void setCashStatus(String cashStatus) {
        this.cashStatus = cashStatus;
    }

    public Date getPayDate() {
        return payDate;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getPayeePhone() {
        return payeePhone;
    }

    public void setPayeePhone(String payeePhone) {
        this.payeePhone = payeePhone;
    }

    public String getBankCardNo() {
        return bankCardNo;
    }

    public void setBankCardNo(String bankCardNo) {
        this.bankCardNo = bankCardNo;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getBankPayDate() {
        return bankPayDate;
    }

    public void setBankPayDate(String bankPayDate) {
        this.bankPayDate = bankPayDate;
    }

    public String getPayPlatForm() {
        return payPlatForm;
    }

    public void setPayPlatForm(String payPlatForm) {
        this.payPlatForm = payPlatForm;
    }

    public String getPayCompany() {
        return payCompany;
    }

    public void setPayCompany(String payCompany) {
        this.payCompany = payCompany;
    }

    public String getPayFileName() {
        return payFileName;
    }

    public void setPayFileName(String payFileName) {
        this.payFileName = payFileName;
    }

    public String getPayFileUrl() {
        return payFileUrl;
    }

    public void setPayFileUrl(String payFileUrl) {
        this.payFileUrl = payFileUrl;
    }
}
