package com.biz.crm.taxpay.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 消费者红包提现流水记录请求对象
 */
public class TaxConsumerCashRecordRequest implements Serializable {

    //业务系统单号
    private String cashCode;
    //红包池账户编码
    private String poolAccountCode;
    //红包金额 单位:元
    private BigDecimal amount;

    //打款状态 1-已打款 2-未打款 3-打款中 4-打款失败
    private String cashStatus;

    //商户批次号
    private String requestId;

    //打款时间
    private Date payDate;

    //到账时间
    private Date receiveDate;

    //微信AppID
    private String weChatAppId;

    //收款人名称(非必填)
    private String payeeName;

    //收款人手机号(非必填)
    private String payeeMobile;

    //收款人账号
    private String payeeAccountNo;

    //转账业务的标题
    private String orderTitle;

    //收款备注
    private String remark;

    //创建时间
    private Date createTime;

    //修改时间
    private Date updateTime;
    /**
     * 来源系统
     */
    private String sourceType;

    /**
     * 来源系统名称
     */
    private String sourceTypeName;

    private String appid;


    public String getCashCode() {
        return cashCode;
    }

    public void setCashCode(String cashCode) {
        this.cashCode = cashCode;
    }

    public String getPoolAccountCode() {
        return poolAccountCode;
    }

    public void setPoolAccountCode(String poolAccountCode) {
        this.poolAccountCode = poolAccountCode;
    }


    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCashStatus() {
        return cashStatus;
    }

    public void setCashStatus(String cashStatus) {
        this.cashStatus = cashStatus;
    }

    public Date getPayDate() {
        return payDate;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public String getWeChatAppId() {
        return weChatAppId;
    }

    public void setWeChatAppId(String weChatAppId) {
        this.weChatAppId = weChatAppId;
    }

    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getPayeeMobile() {
        return payeeMobile;
    }

    public void setPayeeMobile(String payeeMobile) {
        this.payeeMobile = payeeMobile;
    }

    public String getPayeeAccountNo() {
        return payeeAccountNo;
    }

    public void setPayeeAccountNo(String payeeAccountNo) {
        this.payeeAccountNo = payeeAccountNo;
    }

    public String getOrderTitle() {
        return orderTitle;
    }

    public void setOrderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }
}
