package com.biz.crm.taxpay.model;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;

/**
 * 税筹可提税率配置
 */
public class TaxGovRateConfigResponse {
    private static final NumberFormat percentFormat = NumberFormat.getPercentInstance();

    private String id;

    //等级
    private Integer taxLevel;

    //区最最小值
    private BigDecimal taxMinAmount;

    //区间最大值
    private BigDecimal taxMaxAmount;

    //税率
    private BigDecimal taxRatePercent;

    //税率
    private String taxRatePercentFormat;

    //当月最大提现金额
    private BigDecimal taxMonthMaxAmount;

    //生效开始时间
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    //生效结束时间
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    //创建时间
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime ;

    //备注
    private String remarks;

    public void setId(String id) {
        this.id = id;
    }

    public void setTaxLevel(Integer taxLevel) {
        this.taxLevel = taxLevel;
    }

    public void setTaxMinAmount(BigDecimal taxMinAmount) {
        this.taxMinAmount = taxMinAmount;
    }

    public void setTaxMaxAmount(BigDecimal taxMaxAmount) {
        this.taxMaxAmount = taxMaxAmount;
    }

    public void setTaxRatePercent(BigDecimal taxRatePercent) {
        this.taxRatePercent = taxRatePercent;
    }

    public void setTaxRatePercentFormat(String taxRatePercentFormat) {
        this.taxRatePercentFormat = taxRatePercentFormat;
    }

    public void setTaxMonthMaxAmount(BigDecimal taxMonthMaxAmount) {
        this.taxMonthMaxAmount = taxMonthMaxAmount;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getId() {
        return id;
    }

    public Integer getTaxLevel() {
        return taxLevel;
    }

    public BigDecimal getTaxMinAmount() {
        return taxMinAmount;
    }

    public BigDecimal getTaxMaxAmount() {
        return taxMaxAmount;
    }

    public BigDecimal getTaxRatePercent() {
        return taxRatePercent;
    }

    public BigDecimal getTaxMonthMaxAmount() {
        return taxMonthMaxAmount;
    }

    public Date getStartTime() {
        return startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getRemarks() {
        return remarks;
    }

    public String getTaxRatePercentFormat() {
        if(taxRatePercent==null){
            return null;
        }
        // 设置最大小数位数为2位（可选）
        percentFormat.setMaximumFractionDigits(2);
        // 格式化数字为百分数
        return percentFormat.format(this.taxRatePercent);
    }
}
