/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.taxpay.exception;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.taxpay.model.TaxBaseResponse;

public class HttpRequestException
extends RuntimeException {
    private final int httpStatusCode;
    private final String responseBody;
    private Integer errorCode;
    private String errorMessage;

    public HttpRequestException(int httpStatusCode, String responseBody) {
        super(String.format("\u8bf7\u6c42\u51fa\u9519:[%d]%nhttpResponseBody[%.1024s]%n", httpStatusCode, responseBody));
        this.httpStatusCode = httpStatusCode;
        this.responseBody = responseBody;
        if (responseBody != null && !responseBody.isEmpty()) {
            TaxBaseResponse taxBaseResponse = (TaxBaseResponse)JSONObject.parseObject((String)responseBody, TaxBaseResponse.class);
            this.errorCode = taxBaseResponse.getCode();
            this.errorMessage = taxBaseResponse.getMessage();
        }
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

