package com.biz.crm.tpm.business.third.system.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.MemberRedPacketDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.service.RedPayLedgerVoService;
import com.biz.crm.tpm.business.third.system.sdk.constants.RedPacketConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/31 11:29
 * @description：成员红包消费
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = RedPacketConstant.TPM_MEMBER_RED_PACKET_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RedPacketConstant.TPM_MEMBER_RED_PACKET_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RedPacketConstant.TPM_MEMBER_RED_PACKET_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY)
public class MemberRedPacketConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private RedPayLedgerVoService redPayLedgerVoService;

    @Override
    protected Object handleMessage(MqMessageVo message) {

        log.info("会员接口消费mq：{}", message.getMsgBody());
        List<MemberRedPacketDto> memberRedPacketDtos = JSON.parseArray(message.getMsgBody(), MemberRedPacketDto.class);
        if (CollectionUtils.isNotEmpty(memberRedPacketDtos)) {
            redPayLedgerVoService.saveBatchMemberRedPacket(memberRedPacketDtos);
        }
        return "消费成功";
    }
}
