package com.biz.crm.tpm.business.third.system.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.auth.sdk.aop.SignHeader;
import com.biz.crm.mn.third.system.a.pallet.goods.dto.APalletGoodsTransferDto;
import com.biz.crm.mn.third.system.a.pallet.goods.service.APalletGoodsTransferService;
import com.biz.crm.tpm.business.third.system.local.entity.APalletGoods;
import com.biz.crm.tpm.business.third.system.sdk.dto.APalletGoodsDto;
import com.biz.crm.tpm.business.third.system.sdk.service.APalletGoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 一盘货相关接口
 *
 * @author liyang
 * @date 2024/04/09
 */
@Slf4j
@RestController
@RequestMapping("/v1/aPalletGoods")
@Api(tags = "一盘货相关接口", hidden = true)
public class APalletGoodsController {

  @Autowired(required = false)
  private APalletGoodsService aPalletGoodsService;

  @ApiOperation(value = "一盘货:费用预算划拨调整申请")
  @PostMapping(value = "/feeAdjustApply")
  @SignHeader
  public Result feeAdjustApply(@RequestBody APalletGoodsTransferDto<APalletGoodsDto> dto) {
    try {
      aPalletGoodsService.feeAdjustApply(dto);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
