package com.biz.crm.tpm.business.third.system.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.local.service.PullCeSalesDataService;
import com.biz.crm.tpm.business.third.system.sdk.constants.CeConstant;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2023/1/14 20:17
 * @ClassName Cee1Controller
 * @Description TODO
 */
@RestController
@Api(tags = "电商日销售数据报表")
@RequestMapping("/v1/ce1")
@Slf4j
public class Ce1Controller {

    @Autowired(required = false)
    private Ce1MnjtService ce1MnjtService;

    @Autowired(required = false)
    private PullCeSalesDataService pullCeSaleDataTaskService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private LoginUserService loginUserService;


    @ApiOperation(value = "分页查询电商日销售数据报表")
    @GetMapping("findDaySalesByConditions")
    public Result<Page<Ce1MnjtFullVo2>> findDaySalesByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "salesPlanDto", value = "电商日销售数据") Ce1MnjtFullDto dto) {
        try {
            Page<Ce1MnjtFullVo2> page = this.ce1MnjtService.findDaySalesByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "分页查询平台价格对比报表")
    @GetMapping("findPlatformPriceConditions")
    public Result<Page<PlatformPriceVo>> findPlatformPriceConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                     @ApiParam(name = "salesPlanDto", value = "电商日销售数据") Ce1MnjtFullDto dto) {
        try {
            Page<PlatformPriceVo> page = this.ce1MnjtService.findPlatformPriceConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "考勤通报管理查询分摊数据")
    @GetMapping("findExamineCircularDataList")
    public Result<List<Ce1ExamineCircularSearchVo>> findExamineCircularDataList(
            @ApiParam(name = "Ce1ExamineCircularSearchDto", value = "考勤通报管理查询分摊数据条件") Ce1ExamineCircularSearchDto dto,
            @ApiParam(name = "cacheKey", value = "缓存key(UUID+业务单元编码)") @RequestParam String cacheKey) {
        try {
            return Result.ok(this.ce1MnjtService.findExamineCircularDataList(dto, cacheKey));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("日销售报表手动拉取")
    @GetMapping("dailySalesReport")
    public Result<?> dailySalesReport(@RequestParam("ds") String ds,
                                      @RequestParam(value = "createDate", required = false) String createDate) {

        try {
            if (StringUtils.isEmpty(ds)) {
                ds = DateUtil.format(DateUtil.dateAddDay(new Date(), -1), "yyyyMMdd");
            }
            boolean hasLock = redisService.hasKey(CeConstant.PULL_SALES_DATA_LOCK + ds);
            if (hasLock) {
                return Result.error("上次拉取还未完成,请耐性等待!");
            }
            pullCeSaleDataTaskService.pullSalesDataReportAsync(ds, createDate, loginUserService.getAbstractLoginUser());
            return Result.ok();
        } catch (Exception e) {
            log.error("日销售报表拉取异常:{}", e.getMessage());
            return Result.error(e.getMessage());
        }
    }
}
