package com.biz.crm.tpm.business.third.system.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.dataphin.sdk.service.DataPhinZmsd121Service;
import com.biz.crm.mn.third.system.dataphin.sdk.service.DataPhinZmsd187Service;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Zmsd121Vo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.AccountCheckBillDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.ContractDocumentDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicSignatureApiService;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.CreateContractVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.ElectronicSignatureVo;
import com.biz.crm.mn.third.system.red.packet.sdk.dto.RedPacketQuerySchemeDto;
import com.biz.crm.mn.third.system.red.packet.sdk.service.RedPacketService;
import com.biz.crm.mn.third.system.red.packet.sdk.vo.RedPacketQuerySchemeVo;
import com.biz.crm.tpm.business.third.system.local.service.PullFeePoolDataService;
import com.biz.crm.tpm.business.third.system.sdk.constants.FeePoolConstant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.util.Calendar;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/22 20:08
 * @description：测试
 */
@RestController
@Api(tags = "手动调用第三方相关接口")
@RequestMapping("/v1/manualController")
@Slf4j
public class ManualController {

    @Autowired
    private ElectronicSignatureApiService electronicSignatureApiService;

    @Autowired(required = false)
    private RedPacketService redPacketService;

    @Autowired(required = false)
    private PullFeePoolDataService pullFeePoolDataService;

    @Autowired(required = false)
    private DataPhinZmsd187Service dataPhinZmsd187Service;

    @Autowired(required = false)
    private DataPhinZmsd121Service dataPhinZmsd121Service;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    @PostMapping("pushAccountCheckBillTest")
    public ElectronicSignatureVo<CreateContractVo> test(@RequestBody AccountCheckBillDto dto) {
        ContractDocumentDto contractDocumentDto = dto.getContractDocumentDto();
        File file = new File(dto.getContractDto().getCustomerCode());
        contractDocumentDto.setAccountCheckBillFile(file);
        return electronicSignatureApiService.pushAccountCheckBill(dto);
    }

//    @GetMapping("dataphin")
//    public void dataphin(){
//        dataphinService.dataphinTest();
//    }

    @PostMapping("testRedPacket")
    public Result<List<RedPacketQuerySchemeVo>> testRedPacket(@RequestBody RedPacketQuerySchemeDto dto) {
        return Result.ok(redPacketService.redPacketQueryScheme(dto));
    }

    @PostMapping("test187")
    public Result<?> test187(Integer pageNum, Integer pageSize, String ds, String accountingPeriod) {
        return Result.ok(dataPhinZmsd187Service.getZmsd187Data(ds, accountingPeriod, pageNum, pageSize));
    }

    @PostMapping("test121")
    public Result<?> test121(Integer pageNum, Integer pageSize, String ds, String accountingPeriod) {
        return Result.ok(dataPhinZmsd121Service.getZmsd121Data(ds, accountingPeriod, pageNum, pageSize));
    }

    /**
     * 手动拉取费用池余额数据接口
     *
     * @param vo
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author jiangyin
     * @date 2023/3/8 20:24
     */
    @ApiOperation(value = "手动拉取费用池余额数据接口", notes = "")
    @PostMapping("manualFeePool")
    public Result<?> manualFeePool(@RequestBody Zmsd121Vo vo) {
        boolean lock = redisService.hasKey(FeePoolConstant.PULL_FEE_POOL_DATA_LOCK);
        if (lock) {
            return Result.error("上次拉取尚未完成,请耐性等待!");
        }
        try {
            String ds = vo.getDs();
            if (StringUtil.isEmpty(ds)) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(Calendar.DAY_OF_MONTH, 1);
                ds = DateUtil.format(calendar.getTime(), "yyyyMMdd");
            }
            String accountingPeriod = vo.getAccounting_period();
            if (StringUtil.isEmpty(accountingPeriod)) {
                int month = Integer.parseInt(ds.substring(4, 6));
                if (month == 1) {
                    month = 12;
                } else {
                    month--;
                }
                accountingPeriod = String.format("%02d", month);
            }
            pullFeePoolDataService.pullFeePoolDataAsync(ds, accountingPeriod, loginUserService.getAbstractLoginUser());
        } catch (Exception e) {
            log.error("", e);
            return Result.error(e.getMessage());
        }
        return Result.ok();
    }
}