package com.biz.crm.tpm.business.third.system.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.third.system.sdk.constants.CeConstant;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmZtfi099ForEctQueryDto;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Sap099获利能力分析数据表(TpmProfitabilityAnalysis)表控制层
 *
 * @author huanglong
 * @date 2023-01-13 12:01:43
 */
@Slf4j
@Api(tags = "Sap099获利能力分析数据表")
@RestController
@RequestMapping(value = {"/v1/tpmProfitabilityAnalysis"})
public class TpmProfitabilityAnalysisController {

    @Autowired(required = false)
    private TpmProfitabilityAnalysisService tpmProfitabilityAnalysisService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;


    /**
     * 手动同步获利能力分析数据099(日期格式202211)
     *
     * @param yearMonth 条件
     */
    @ApiOperation(value = "手动同步获利能力分析数据099(日期格式202211)")
    @GetMapping("handExecZtfi099")
    public Result<?> handExecZtfi099(@RequestParam(value = "yearMonth", required = false) String yearMonth,
                                     @RequestParam(value = "companyCode", required = false) String companyCode,
                                     @RequestParam(value = "accountDate", required = false) String accountDate) {
        try {
            Assert.hasText(yearMonth, "年月不能为空");
            if (yearMonth.contains("-")) {
                yearMonth = yearMonth.replace("-", "");
            }
            if (StringUtils.isNotEmpty(accountDate)
                    && accountDate.contains("-")) {
                accountDate = accountDate.replace("-", "");
            }
            Assert.isTrue(yearMonth.length() == 6, "年月格式不合法![yyyyMM]");
            String lockKey = CeConstant.BJX099_PULL_LOCK_PREFIX + yearMonth;
            boolean isLock = redisLockService.isLock(lockKey);
            Assert.isTrue(!isLock, "上次拉取【" + yearMonth + "】月尚未完成");
            this.tpmProfitabilityAnalysisService.handPull099ByYearMonthAsync(yearMonth, companyCode, accountDate);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取tpm中已存入的099数据
     */
    @ApiOperation(value = "获取tpm中已存入的099数据")
    @GetMapping("/findData4Ect")
    public Result<Page<TpmProfitabilityAnalysisVo>> findData4Ect(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "ectZtfi099QueryDto", value = "ectZtfi099QueryDto") TpmZtfi099ForEctQueryDto ectZtfi099QueryDto) {
        try {
            Page<TpmProfitabilityAnalysisVo> data4Ect = tpmProfitabilityAnalysisService.findData4Ect(pageable, ectZtfi099QueryDto);
            return Result.ok(data4Ect);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
