package com.biz.crm.tpm.business.third.system.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * @TableName tpm_a_pallet_goods
 */
@Data
@ApiModel(value = "APalletGoods", description = "TPM-一盘货")
@TableName("tpm_a_pallet_goods")
@Getter
@Setter
@Entity(name = "tpm_a_pallet_goods")
@org.hibernate.annotations.Table(appliesTo = "tpm_a_pallet_goods", comment = "TPM-一盘货")
@Table(name = "tpm_a_pallet_goods", indexes = {})
public class APalletGoods extends TenantFlagOpEntity {

    @Column(name = "invoice_no", columnDefinition = "varchar(64) COMMENT '单据号'")
    private String invoiceNo;

    @Column(name = "item_no", columnDefinition = "varchar(32) COMMENT '行项目号'")
    private String itemNo;

    @Column(name = "business_format_code", columnDefinition = "varchar(32) COMMENT '业态'")
    private	String businessFormatCode;

    @Column(name = "out_business_unit", columnDefinition = "varchar(64) COMMENT '调出方业务单元/区域'")
    private	String outBusinessUnit;

    @Column(name = "in_business_unit", columnDefinition = "varchar(64) COMMENT '调入方业务单元/区域'")
    private	String inBusinessUnit;

    @Column(name = "product_code", columnDefinition = "varchar(32) COMMENT '产品编码'")
    private	String productCode;

    @Column(name = "product_name", columnDefinition = "varchar(64) COMMENT '产品名称'")
    private	String productName;

    @Column(name = "logic_warehouse", columnDefinition = "varchar(64) COMMENT '逻辑仓库'")
    private	String logicWarehouse;

    @Column(name = "quantity", columnDefinition = "int(11) COMMENT '数量'")
    private	Integer quantity;

    @Column(name = "factory_price", columnDefinition = "decimal(24,6) COMMENT '出厂价'")
    private BigDecimal factoryPrice;

    @Column(name = "transfer_date", columnDefinition = "varchar(32) COMMENT '划拨日期'")
    private String transferDate;

    @Column(name = "suggested_points", columnDefinition = "decimal(24,6) COMMENT '建议点数'")
    private BigDecimal suggestedPoints;

    @Column(name = "float_points", columnDefinition = "decimal(24,6) COMMENT '浮动点数'")
    private BigDecimal floatPoints;

    @Column(name = "float_reason", columnDefinition = "varchar(128) COMMENT '浮动原因'")
    private String floatReason;

    @Column(name = "out_points", columnDefinition = "decimal(24,6) COMMENT '调出方承担点数'")
    private BigDecimal outPoints;

    @Column(name = "third_points", columnDefinition = "decimal(24,6) COMMENT '第三方承担点数'")
    private BigDecimal thirdPoints;

    @Column(name = "cost", columnDefinition = "decimal(24,6) COMMENT '费用金额（元）'")
    private BigDecimal cost;

    @Column(name = "status", columnDefinition = "varchar(8) COMMENT '费用调整状态'")
    private String status;
}