package com.biz.crm.tpm.business.third.system.local.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 电商拉取CE日销售数据锁定
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-11-23 10:54
 */
@ApiModel(value = "Ce1MnLock", description = "电商拉取CE日销售数据锁定")
@TableName("tpm_ce1_mn_lock")
@Getter
@Setter
@Entity(name = "tpm_ce1_mn_lock")
@org.hibernate.annotations.Table(appliesTo = "tpm_ce1_mn_lock", comment = "电商拉取CE日销售数据锁定")
@Table(name = "tpm_ce1_mn_lock", indexes = {
        @Index(name = "tpm_ce1_mn_lock_idx1", columnList = "expire_time", unique = false),
        @Index(name = "tpm_ce1_mn_lock_idx2", columnList = "ds", unique = true),
})
@Data
public class Ce1MnLock implements Serializable {

    @Id
    @GeneratedValue(generator = "uuid")
    @TableId(type = IdType.ASSIGN_UUID)
    @GenericGenerator(name = "uuid", strategy = "org.hibernate.id.UUIDGenerator")
    @TableField(value = "id")
    @Column(name = "id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '主键'")
    private String id;

    @ApiModelProperty("过期时间")
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "expire_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '过期时间 '")
    private Date expireTime;

    @ApiModelProperty("时间分区")
    @Column(name = "ds", nullable = false, length = 20, columnDefinition = "varchar(20) COMMENT '时间分区'")
    private String ds;

    @ApiModelProperty("CE创建时间")
    @Column(name = "ce_create_date", length = 20, columnDefinition = "varchar(20) COMMENT 'CE创建时间'")
    private String ceCreateDate;

    @ApiModelProperty("已重试次数")
    @Column(name = "retry_time", nullable = false, columnDefinition = "decimal(20,0) COMMENT '已重试次数'")
    private Integer retryTime;

    @ApiModelProperty("当前页")
    @Column(name = "current_page_number", nullable = false, columnDefinition = "decimal(20,0) COMMENT '当前页'")
    private Integer currentPageNumber;

    @ApiModelProperty("总数据量")
    @Column(name = "total", nullable = false, columnDefinition = "decimal(20,0) COMMENT '总数据量'")
    private Integer total;

}
