package com.biz.crm.tpm.business.third.system.local.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @TableName tpm_ce1_mnjt
 */
@Data
@ApiModel(value = "Ce1Mnjt", description = "TPM-费用池余额-121表数据")
@TableName("tpm_ce1_mnjt")
@Getter
@Setter
@Entity(name = "tpm_ce1_mnjt")
@org.hibernate.annotations.Table(appliesTo = "tpm_ce1_mnjt", comment = "TPM-费用池余额-121表数据")
@Table(name = "tpm_ce1_mnjt", indexes = {
        @Index(name = "tpm_ce1_mnjt_idx1", columnList = "c_id", unique = false),
        @Index(name = "tpm_ce1_mnjt_idx2", columnList = "post_date", unique = false),
        @Index(name = "tpm_ce1_mnjt_idx3", columnList = "customer_code", unique = false),
        @Index(name = "tpm_ce1_mnjt_idx4", columnList = "ds", unique = false),
        @Index(name = "tpm_ce1_mnjt_idx5", columnList = "verify_code", unique = false),
})
public class Ce1Mnjt implements Serializable {

    @Id
    @GeneratedValue(
            generator = "uuid"
    )
    @TableId(
            type = IdType.ASSIGN_UUID
    )
    @GenericGenerator(
            name = "uuid",
            strategy = "org.hibernate.id.UUIDGenerator"
    )
    @Column(name = "id", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT 'ID'")
    private String id;

    @Column(name = "c_id", length = 64, columnDefinition = "varchar(64)")
    private String cId;

    @Column(name = "mandt", length = 64, columnDefinition = "varchar(64) COMMENT 'SAP客户端'")
    private String mandt;

    @Column(name = "business_scope_currency_type", length = 64, columnDefinition = "varchar(64) COMMENT '经营范围的货币类型'")
    private String businessScopeCurrencyType;

    @Column(name = "record_type", length = 10, columnDefinition = "varchar(10) COMMENT '记录类型'")
    private String recordType;

    @Column(name = "plan_edition_co_pa", length = 64, columnDefinition = "varchar(64) COMMENT '计划版本(CO-PA)'")
    private String planEditionCoPa;

    @Column(name = "period_year", length = 64, columnDefinition = "varchar(64) COMMENT '期间/年度'")
    private String periodYear;

    @Column(name = "profitability_segment_number_copa", length = 10, columnDefinition = "varchar(10) COMMENT '获利能力段编号(CO-PA)'")
    private String profitabilitySegmentNumberCopa;

    @Column(name = "profit_segment_modify_co_pa", length = 64, columnDefinition = "varchar(64) COMMENT '获利能力的段修改(CO-PA)'")
    private String profitSegmentModifyCoPa;


    @Column(name = "profit_segment_line_item_voucher_num", length = 64, columnDefinition = "varchar(64) COMMENT '获利分段行项目的凭证号'")
    private String profitSegmentLineItemVoucherNum;


    @Column(name = "co_pa_line_item_item_num", length = 64, columnDefinition = "varchar(64) COMMENT 'CO-PA行项目的项目号'")
    private String coPaLineItemItemNum;


    @Column(name = "document_creat_date", length = 32, columnDefinition = "varchar(32) COMMENT '记录的创建日期'")
    private String documentCreatDate;


    @Column(name = "creator", length = 64, columnDefinition = "varchar(64) COMMENT '创建人'")
    private String creator;


    @Column(name = "fiscal_year", length = 64, columnDefinition = "varchar(64) COMMENT '财年'")
    private String fiscalYear;


    @Column(name = "period", length = 64, columnDefinition = "varchar(64) COMMENT '期间'")
    private String period;


    @Column(name = "delivery_date", length = 32, columnDefinition = "varchar(32) COMMENT '发货日期'")
    private String deliveryDate;


    @Column(name = "invoice_date_create_date", length = 32, columnDefinition = "varchar(32) COMMENT '发票日期(创建日期)'")
    private String invoiceDateCreateDate;

    @ApiModelProperty("过帐日期")
    @Column(name = "post_date", length = 32, columnDefinition = "varchar(32) varchar(32) COMMENT '过帐日期'")
    private String postDate;


    @Column(name = "period_year_optional_period_type", length = 64, columnDefinition = "varchar(64) COMMENT '期间/年在可选的期间类型'")
    private String periodYearOptionalPeriodType;


    @Column(name = "partner_profit_segment_num_co_pa", length = 64, columnDefinition = "varchar(64) COMMENT '伙伴获利能力的段号(CO-PA)'")
    private String partnerProfitSegmentNumCoPa;


    @Column(name = "modify_partner_profit_segment_co_pa", length = 64, columnDefinition = "varchar(64) COMMENT '修改伙伴获利能力段(CO-PA)'")
    private String modifyPartnerProfitSegmentCoPa;


    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) varchar(32) COMMENT '客户代码'")
    private String customerCode;


    @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品代码'")
    private String productCode;


    @Column(name = "invoicing_type_code", length = 64, columnDefinition = "varchar(64) COMMENT '开票类型代码'")
    private String invoicingTypeCode;


    @Column(name = "foreign_currency_code", length = 64, columnDefinition = "varchar(64) COMMENT '外币码'")
    private String foreignCurrencyCode;


    @Column(name = "exchange_rate", length = 64, columnDefinition = "varchar(64) COMMENT '汇率'")
    private String exchangeRate;


    @Column(name = "exchange_rate_business_scope_currency_company_code_currency", length = 64, columnDefinition = "varchar(64) COMMENT '汇率对于经营范围货币->公司代码货币'")
    private String exchangeRateBusinessScopeCurrencyCompanyCodeCurrency;


    @Column(name = "exchange_rate_business_scope_currency_currency_group", length = 64, columnDefinition = "varchar(64) COMMENT '汇率经营范围货币->货币组'")
    private String exchangeRateBusinessScopeCurrencyCurrencyGroup;


    @Column(name = "data_record_currency", length = 64, columnDefinition = "varchar(64) COMMENT '数据记录货币'")
    private String dataRecordCurrency;


    @Column(name = "sales_orders_num", length = 64, columnDefinition = "varchar(64) COMMENT '销售订单数'")
    private String salesOrdersNum;


    @Column(name = "sales_order_item_num", length = 64, columnDefinition = "varchar(64) COMMENT '销售订单中的项目编号'")
    private String salesOrderItemNum;


    @Column(name = "order_code", length = 64, columnDefinition = "varchar(64) COMMENT '订单号'")
    private String orderCode;


    @Column(name = "sender_cost_center", length = 64, columnDefinition = "varchar(64) COMMENT '发送方成本中心'")
    private String senderCostCenter;


    @Column(name = "sender_business_processing", length = 64, columnDefinition = "varchar(64) COMMENT '发送方业务处理'")
    private String senderBusinessProcessing;


    @Column(name = "company_code", length = 64, columnDefinition = "varchar(64) COMMENT '公司代码'")
    private String companyCode;


    @Column(name = "control_scope", length = 64, columnDefinition = "varchar(64) COMMENT '控制范围'")
    private String controlScope;


    @Column(name = "factory_code", length = 64, columnDefinition = "varchar(64) COMMENT '工厂代码'")
    private String factoryCode;


    @Column(name = "business_scope", length = 64, columnDefinition = "varchar(64) COMMENT '业务范围'")
    private String businessScope;


    @Column(name = "sale_org_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售组织代码'")
    private String saleOrgCode;


    @Column(name = "distribution_channel_code", length = 64, columnDefinition = "varchar(64) COMMENT '分销渠道代码'")
    private String distributionChannelCode;


    @Column(name = "product_team_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品组代码'")
    private String productTeamCode;


    @Column(name = "source_co_pa", length = 64, columnDefinition = "varchar(64) COMMENT '来源(CO-PA)'")
    private String sourceCoPa;


    @Column(name = "plan_actual_flag", length = 64, columnDefinition = "varchar(64) COMMENT '计划/实际标识'")
    private String planActualFlag;


    @Column(name = "cost_element_code", length = 64, columnDefinition = "varchar(64) COMMENT '成本要素代码'")
    private String costElementCode;


    @Column(name = "work_breakdown_structure_element", length = 64, columnDefinition = "varchar(64) COMMENT '工作分解结构元素(WBS元素)'")
    private String workBreakdownStructureElement;


    @Column(name = "cost_object", length = 64, columnDefinition = "varchar(64) COMMENT '成本对象'")
    private String costObject;


    @Column(name = "reference_document_num_co_pa_line_item", length = 64, columnDefinition = "varchar(64) COMMENT '参考凭证号对于CO-PA行项目'")
    private String referenceDocumentNumCoPaLineItem;


    @Column(name = "item_num_from_reference_text_co_pa", length = 64, columnDefinition = "varchar(64) COMMENT '从参考文本的项目号(CO-PA)'")
    private String itemNumFromReferenceTextCoPa;


    @Column(name = "canceled_voucher", length = 64, columnDefinition = "varchar(64) COMMENT '已取消凭证'")
    private String canceledVoucher;


    @Column(name = "canceled_voucher_item", length = 64, columnDefinition = "varchar(64) COMMENT '已取消凭证项目'")
    private String canceledVoucherItem;


    @Column(name = "profit_center_code", length = 64, columnDefinition = "varchar(64) COMMENT '利润中心代码'")
    private String profitCenterCode;


    @Column(name = "partner_profit_center", length = 64, columnDefinition = "varchar(64) COMMENT '伙伴利润中心'")
    private String partnerProfitCenter;


    @Column(name = "update_status_co_pa_line_items", length = 64, columnDefinition = "varchar(64) COMMENT '更新状态对于CO-PA行项目'")
    private String updateStatusCoPaLineItems;


    @Column(name = "time_create_greenwich_mean_time", length = 64, columnDefinition = "varchar(64) COMMENT '创建的时间(格林威治时间)'")
    private String timeCreateGreenwichMeanTime;


    @Column(name = "reference_transaction", length = 64, columnDefinition = "varchar(64) COMMENT '参考交易'")
    private String referenceTransaction;


    @Column(name = "reference_org_unit", length = 64, columnDefinition = "varchar(64) COMMENT '参考组织单位'")
    private String referenceOrgUnit;


    @Column(name = "co_pa_valuation_point", length = 64, columnDefinition = "varchar(64) COMMENT 'CO-PA估价点'")
    private String coPaValuationPoint;


    @Column(name = "source_voucher_logical_system", length = 64, columnDefinition = "varchar(64) COMMENT '源凭证的逻辑系统'")
    private String sourceVoucherLogicalSystem;


    @Column(name = "customer_group_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户组代码'")
    private String customerGroupCode;


    @Column(name = "material_group_code", length = 64, columnDefinition = "varchar(64) COMMENT '物料组代码'")
    private String materialGroupCode;


    @Column(name = "product_level_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品层次代码'")
    private String productLevelCode;


    @Column(name = "co_pa_partner", length = 64, columnDefinition = "varchar(64) COMMENT 'CO-PA合作伙伴'")
    private String coPaPartner;


    @Column(name = "sale_office_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售办公室代码'")
    private String saleOfficeCode;

    @Column(name = "brand", length = 64, columnDefinition = "varchar(64) COMMENT '品牌代码'")
    private String brand;

    @Column(name = "ds", length = 8, columnDefinition = "varchar(8) COMMENT '时间分区'")
    private String ds;

    @Column(name = "crm_customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '拼接后的客户编码'")
    private String crmCustomerCode;

    @Column(name = "verify_code", length = 512, columnDefinition = "varchar(512) COMMENT '冗余字段-去重'")
    private String verifyCode;

    @Column(name = "month_verify_code", length = 256, columnDefinition = "varchar(256) COMMENT '月销售报表唯一维度'")
    private String monthVerifyCode;

    @Column(name = "day_sale_verify_code", length = 256, columnDefinition = "varchar(256) COMMENT '日销售唯一维度'")
    private String daySaleVerifyCode;

}