package com.biz.crm.tpm.business.third.system.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 
 * @TableName tpm_ce1_mnjt_info
 */
@TableName(value ="tpm_ce1_mnjt_info")
@Data
public class Ce1MnjtInfo implements Serializable {
    /**
     * 主键id
     */
    @TableId(value = "id")
    private String id;

    /**
     * tpm_ce1_mnjt主表id
     */
    @TableField(value = "tpm_ce1_mnjt_id")
    private String tpmCe1MnjtId;

    /**
     * 成本中心
     */
    @TableField(value = "cost_center")
    private String costCenter;

    /**
     * 销售组代码
     */
    @TableField(value = "sale_group_code")
    private String saleGroupCode;

    /**
     * 送达方代码
     */
    @TableField(value = "sender_code")
    private String senderCode;

    /**
     * 销售人员
     */
    @TableField(value = "salesman")
    private String salesman;

    /**
     * 销售地区代码
     */
    @TableField(value = "sale_area_code")
    private String saleAreaCode;

    /**
     * 国家代码
     */
    @TableField(value = "country_code")
    private String countryCode;

    /**
     * 基本计量单位
     */
    @TableField(value = "measure_base_unit")
    private String measureBaseUnit;

    /**
     * 基本计量单位2
     */
    @TableField(value = "basic_uom_2")
    private String basicUom2;

    /**
     * 基本计量单位3
     */
    @TableField(value = "basic_uom_3")
    private String basicUom3;

    /**
     * 基本计量单位4
     */
    @TableField(value = "basic_uom_4")
    private String basicUom4;

    /**
     * 基本计量单位5
     */
    @TableField(value = "basic_uom_5")
    private String basicUom5;

    /**
     * 基本计量单位6
     */
    @TableField(value = "basic_uom_6")
    private String basicUom6;

    /**
     * 销售数量
     */
    @TableField(value = "sales_volumes")
    private BigDecimal salesVolumes;

    /**
     * 固定生产成本
     */
    @TableField(value = "fixed_production_cost")
    private String fixedProductionCost;

    /**
     * 比例生产成本
     */
    @TableField(value = "proportional_production_cost")
    private String proportionalProductionCost;

    /**
     * 总销售额
     */
    @TableField(value = "sales_tot")
    private String salesTot;

    /**
     * 批大小差异
     */
    @TableField(value = "batch_size_difference")
    private String batchSizeDifference;

    /**
     * 闲置生产能力成本
     */
    @TableField(value = "idle_production_capacity_cost")
    private String idleProductionCapacityCost;

    /**
     * 数量差异
     */
    @TableField(value = "num_variance")
    private String numVariance;

    /**
     * 价格差异
     */
    @TableField(value = "price_variance")
    private String priceVariance;

    /**
     * 资源利用差异
     */
    @TableField(value = "resource_utilization_variance")
    private String resourceUtilizationVariance;

    /**
     * 其它偏差
     */
    @TableField(value = "other_deviations")
    private String otherDeviations;

    /**
     * 主营业务收入
     */
    @TableField(value = "main_business_income")
    private String mainBusinessIncome;

    /**
     * 其他业务收入
     */
    @TableField(value = "other_business_income")
    private String otherBusinessIncome;

    /**
     * 公允价值变动损益
     */
    @TableField(value = "fair_value_changes_profit_loss")
    private String fairValueChangesProfitLoss;

    /**
     * 投资收益
     */
    @TableField(value = "income_from_investment")
    private String incomeFromInvestment;

    /**
     * 营业外收入
     */
    @TableField(value = "nonbusiness_income")
    private String nonbusinessIncome;

    /**
     * 主营业务成本
     */
    @TableField(value = "main_business_cost")
    private String mainBusinessCost;

    /**
     * 其他业务支出
     */
    @TableField(value = "other_business_expenses")
    private String otherBusinessExpenses;

    /**
     * 营业税金及附加
     */
    @TableField(value = "business_taxes_and_surcharges")
    private String businessTaxesAndSurcharges;

    /**
     * 部门间接费用
     */
    @TableField(value = "department_overhead")
    private String departmentOverhead;

    /**
     * 财务费用
     */
    @TableField(value = "financial_expenses")
    private String financialExpenses;

    /**
     * 资产减值损失
     */
    @TableField(value = "assets_impairment_loss")
    private String assetsImpairmentLoss;

    /**
     * 营业外支出
     */
    @TableField(value = "nonbusiness_expenses")
    private String nonbusinessExpenses;

    /**
     * 所得税费用
     */
    @TableField(value = "income_tax_expense")
    private String incomeTaxExpense;

    /**
     * 以前年度损益调整
     */
    @TableField(value = "prior_year_income_adjustment")
    private String priorYearIncomeAdjustment;

    /**
     * 折前金额
     */
    @TableField(value = "amount_before_discount")
    private String amountBeforeDiscount;

    /**
     * 含税销售额(净额)
     */
    @TableField(value = "sales_including_tax_net")
    private String salesIncludingTaxNet;

    /**
     * 采购成本
     */
    @TableField(value = "purchase_cost")
    private String purchaseCost;

    /**
     * 进项税
     */
    @TableField(value = "input_tax")
    private String inputTax;

    /**
     * 委外材料成本
     */
    @TableField(value = "outsourcing_material_cost")
    private String outsourcingMaterialCost;

    /**
     * 委外加工费
     */
    @TableField(value = "outsourcing_fee")
    private String outsourcingFee;

    /**
     * 委外收货结转
     */
    @TableField(value = "subcontracting_receipt_carry_forward")
    private String subcontractingReceiptCarryForward;

    /**
     * 销售含税金额
     */
    @TableField(value = "sales_tax_amount")
    private String salesTaxAmount;

    /**
     * 金额备用01
     */
    @TableField(value = "amount_reserve_01")
    private String amountReserve01;

    /**
     * 金额备用02
     */
    @TableField(value = "amount_reserve_02")
    private String amountReserve02;

    /**
     * 金额备用03
     */
    @TableField(value = "amount_reserve_03")
    private String amountReserve03;

    /**
     * 金额备用04
     */
    @TableField(value = "amount_reserve_04")
    private String amountReserve04;

    /**
     * 金额备用05
     */
    @TableField(value = "amount_reserve_05")
    private String amountReserve05;

    /**
     * 金额备用06
     */
    @TableField(value = "amount_reserve_06")
    private String amountReserve06;

    /**
     * 标准数量(吨)
     */
    @TableField(value = "standard_num_ton")
    private BigDecimal standardNumTon;

    /**
     * 净重量
     */
    @TableField(value = "net_weight")
    private BigDecimal netWeight;

    /**
     * 毛重
     */
    @TableField(value = "gross_weight")
    private BigDecimal grossWeight;

    /**
     * 业务量
     */
    @TableField(value = "business_num")
    private BigDecimal businessNum;

    /**
     * 分区字段
     */
    @TableField(value = "ds")
    private String ds;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
//
//    /**
//     *成本中心
//     */
//    @TableField(value = "cost_center")
//    private String CostCenter;
//
//    /**
//     * 库存单位销售数量
//     */
//    @TableField(value = "inventory_unit_sales_num")
//    private String inventoryUnitSalesNum;
}