package com.biz.crm.tpm.business.third.system.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * Sap099获利能力分析数据表
 *
 * @author cyj
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = true)
@TableName("tpm_profitability_analysis")
@Table(name = "tpm_profitability_analysis", indexes = {
        @Index(name = "tpm_profitability_analysis_idx1", columnList = "company_code", unique = false),
        @Index(name = "tpm_profitability_analysis_idx2", columnList = "customer_code", unique = false),
        @Index(name = "tpm_profitability_analysis_idx3", columnList = "ds", unique = false),
        @Index(name = "tpm_profitability_analysis_idx4", columnList = "account_date", unique = false),
})
@ApiModel(value = "ProfitabilityAnalysisEntity", description = "Sap099获利能力分析数据表")
@org.hibernate.annotations.Table(appliesTo = "tpm_profitability_analysis", comment = "Sap099获利能力分析数据表")
public class TpmProfitabilityAnalysis extends TenantFlagOpEntity {

  @ApiModelProperty("记录类型")
  @Column(name = "record_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '记录类型'")
  private String recordType;

  @ApiModelProperty("公司代码")
  @Column(name = "company_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '公司代码'")
  private String companyCode;
  @ApiModelProperty("利润中心代码")
  @Column(name = "profit_center_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '利润中心代码'")
  private String profitCenterCode;
  @ApiModelProperty("期间/年度")
  @Column(name = "period", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '期间/年度'")
  private String period;
  @ApiModelProperty("销售订单数")
  @Column(name = "order_num",nullable = true, columnDefinition = "decimal(20,4) COMMENT '销售订单数'")
  private BigDecimal orderNum;
  @ApiModelProperty("获利能力段编号")
  @Column(name = "profitability_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '获利能力段编号'")
  private String profitabilityCode;
  @ApiModelProperty("子编号")
  @Column(name = "profitability_subcode", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '子编号'")
  private String profitabilitySubcode;
  @ApiModelProperty("凭证编号")
  @Column(name = "profitability_vou_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '凭证编号'")
  private String profitabilityVouCode;
  @ApiModelProperty("项目号")
  @Column(name = "profitability_itemno", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '项目号'")
  private String profitabilityItemno;
  @ApiModelProperty("工厂代码")
  @Column(name = "factory_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '工厂代码'")
  private String factoryCode;
  @ApiModelProperty("分销渠道代码")
  @Column(name = "channel_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '分销渠道代码'")
  private String channelCode;
  @ApiModelProperty("分销渠道名称")
  @Column(name = "channel_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '分销渠道名称'")
  private String channelName;
  @ApiModelProperty("产品组代码")
  @Column(name = "spart_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '产品组代码'")
  private String spartCode;
  @ApiModelProperty("货币类型代码")
  @Column(name = "currency_type_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '货币类型代码'")
  private String currencyTypeCode;
  @ApiModelProperty("开票类型")
  @Column(name = "invoice_type", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '开票类型'")
  private String invoiceType;

  @ApiModelProperty("记帐日期")
  @Column(name = "account_date", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '记帐日期'")
  private String accountDate;
  /**
   * 年月
   */
  @ApiModelProperty(value = "年月", notes = "")
  @Column(name = "year_month_ly",  length = 6, columnDefinition = "VARCHAR(6) COMMENT '年月'")
  private String yearMonthLy;

  @ApiModelProperty("售达方代码")
  @Column(name = "dealer_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '售达方代码'")
  private String dealerCode;
  @ApiModelProperty("售达方名称")
  @Column(name = "dealer_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '售达方名称'")
  private String dealerName;
  @ApiModelProperty("物料代码")
  @Column(name = "material_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '物料代码'")
  private String materialCode;
  @ApiModelProperty("物料描述")
  @Column(name = "material", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '物料描述'")
  private String material;
  @ApiModelProperty("品牌代码")
  @Column(name = "brand_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '品牌代码'")
  private String brandCode;
  @ApiModelProperty("品牌描述")
  @Column(name = "brand", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '品牌描述'")
  private String brand;
  @ApiModelProperty("品类代码")
  @Column(name = "category_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '品类代码'")
  private String categoryCode;
  @ApiModelProperty("品类")
  @Column(name = "category_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '品类'")
  private String categoryName;
  @ApiModelProperty("品项代码")
  @Column(name = "item_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '品项代码'")
  private String itemCode;
  @ApiModelProperty("品项")
  @Column(name = "item_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '品项'")
  private String itemName;
  @ApiModelProperty("上市分类代码")
  @Column(name = "list_classify_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '上市分类代码'")
  private String listClassifyCode;
  @ApiModelProperty("送达方代码")
  @Column(name = "service_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '送达方代码'")
  private String serviceCode;
  @ApiModelProperty("送达方名称")
  @Column(name = "service_name", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '送达方名称'")
  private String serviceName;
  @ApiModelProperty("销售人员代码")
  @Column(name = "salesman_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '销售人员代码'")
  private String salesmanCode;
  @ApiModelProperty("销售地区代码")
  @Column(name = "sales_area_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '销售地区代码'")
  private String salesAreaCode;
  @ApiModelProperty("成本要素")
  @Column(name = "cost_element", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '成本要素'")
  private String costElement;
  @ApiModelProperty("成本中心代码")
  @Column(name = "cost_center_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '成本中心代码'")
  private String costCenterCode;
  @ApiModelProperty("税率")
  @Column(name = "tax_rate",nullable = true, columnDefinition = "decimal(10,4) COMMENT '税率'")
  private BigDecimal taxRate;
  @ApiModelProperty("标准供价")
  @Column(name = "standard_supply_price", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '标准供价'")
  private String standardSupplyPrice;
  @ApiModelProperty("标准成本价")
  @Column(name = "standard_cost_price", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '标准成本价'")
  private String standardCostPrice;
  @ApiModelProperty("库存单位销售数量")
  @Column(name = "sales_num",nullable = true, columnDefinition = "decimal(20,4) COMMENT '库存单位销售数量'")
  private BigDecimal salesNum;
  @ApiModelProperty("标准收入（含税）")
  @Column(name = "standard_income_intax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '标准收入（含税）'")
  private BigDecimal standardIncomeIntax;
  @ApiModelProperty("标准收入（未税）")
  @Column(name = "standard_income_notax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '标准收入（未税）'")
  private BigDecimal standardIncomeNotax;
  @ApiModelProperty("实际收入（含税）")
  @Column(name = "actual_income_intax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '实际收入（含税）'")
  private BigDecimal actualIncomeIntax;
  @ApiModelProperty("退货差价")
  @Column(name = "return_price_diff", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '退货差价'")
  private String returnPriceDiff;
  @ApiModelProperty("实际收入（未税）")
  @Column(name = "actual_income_notax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '实际收入（未税）'")
  private BigDecimal actualIncomeNotax;
  @ApiModelProperty("随车折扣")
  @Column(name = "onboard_discount",nullable = true, columnDefinition = "decimal(20,4) COMMENT '随车折扣'")
  private BigDecimal onboardDiscount;
  @ApiModelProperty("随单费用")
  @Column(name = "in_order_expenses",nullable = true, columnDefinition = "decimal(20,4) COMMENT '随单费用'")
  private BigDecimal inOrderExpenses;
  @ApiModelProperty("月末折扣")
  @Column(name = "month_end_discount",nullable = true, columnDefinition = "decimal(20,4) COMMENT '月末折扣'")
  private BigDecimal monthEndDiscount;
  @ApiModelProperty("标准成本（含税）")
  @Column(name = "standard_cost_intax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '标准成本（含税）'")
  private BigDecimal standardCostIntax;
  @ApiModelProperty("标准成本（未税）")
  @Column(name = "standard_cost_notax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '标准成本（未税）'")
  private BigDecimal standardCostNotax;
  @ApiModelProperty("实际成本（含税）")
  @Column(name = "actual_cost_intax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '实际成本（含税）'")
  private BigDecimal actualCostIntax;
  @ApiModelProperty("实际成本（未税）")
  @Column(name = "actual_cost_notax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '实际成本（未税）'")
  private String actualCostNotax;
  @ApiModelProperty("理论毛利(未税)")
  @Column(name = "theory_gross_profit_notax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '理论毛利(未税)'")
  private BigDecimal theoryGrossProfitNotax;
  @ApiModelProperty("理论毛利率(未税)")
  @Column(name = "theory_gross_profit_ratio_notax", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '理论毛利率(未税)'")
  private String theoryGrossProfitRatioNotax;
  @ApiModelProperty("实际毛利(未税)")
  @Column(name = "actual_gross_profit_notax",nullable = true, columnDefinition = "decimal(20,4) COMMENT '实际毛利(未税)'")
  private BigDecimal actualGrossProfitNotax;
  @ApiModelProperty("实际毛利率(未税)")
  @Column(name = "actual_gross_profit_ratio_notax", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '实际毛利率(未税)'")
  private String actualGrossProfitRatioNotax;
  @ApiModelProperty("理论毛利")
  @Column(name = "theory_gross_profit",nullable = true, columnDefinition = "decimal(20,4) COMMENT '理论毛利'")
  private BigDecimal theoryGrossProfit;
  @ApiModelProperty("理论毛利率")
  @Column(name = "theory_gross_profit_ratio", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '理论毛利率'")
  private String theoryGrossProfitRatio;
  @ApiModelProperty("实际毛利")
  @Column(name = "actual_gross_profit",nullable = true, columnDefinition = "decimal(20,4) COMMENT '实际毛利'")
  private BigDecimal actualGrossProfit;
  @ApiModelProperty("实际毛利率")
  @Column(name = "actual_gross_profit_ratio", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '实际毛利率'")
  private String actualGrossProfitRatio;
  @ApiModelProperty("费用ZK50(含ZK00)")
  @Column(name = "cost_zk50", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '费用ZK50(含ZK00)'")
  private String costZk50;
  @ApiModelProperty("搭赠ZK00")
  @Column(name = "gift_zk00", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '搭赠ZK00'")
  private String giftZk00;
  @ApiModelProperty("从条件定价过程小计")
  @Column(name = "condition_price_subtotal", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '从条件定价过程小计'")
  private String conditionPriceSubtotal;
  @ApiModelProperty("分析类型代码")
  @Column(name = "analyse_type_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '分析类型代码'")
  private String analyseTypeCode;
  @ApiModelProperty("分析类型描述")
  @Column(name = "analyse_type", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '分析类型描述'")
  private String analyseType;
  @ApiModelProperty("净重")
  @Column(name = "net_weight",nullable = true, columnDefinition = "decimal(20,4) COMMENT '净重'")
  private BigDecimal netWeight;
  @ApiModelProperty("毛重")
  @Column(name = "gross_weight", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '毛重'")
  private String grossWeight;
  @ApiModelProperty("项目类别")
  @Column(name = "sale_vou_item_type", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '项目类别'")
  private String saleVouItemType;
  @ApiModelProperty("记录日期")
  @Column(name = "record_date", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '记录日期'")
  private String recordDate;
  @ApiModelProperty("时戳")
  @Column(name = "stamp_time", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '时戳'")
  private String stampTime;
  @ApiModelProperty("时间分区")
  @Column(name = "ds", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '时间分区'")
  private String ds;

  @ApiModelProperty(name = "组织编码", notes = "")
  @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
  private String orgCode;

  @ApiModelProperty(name = "组织名称", notes = "")
  @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
  private String orgName;

  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
  private String customerCode;

  @ApiModelProperty("所属销售机构编码")
  @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构编码")
  @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
  private String salesInstitutionErpCode;

  @ApiModelProperty("所属销售机构")
  @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
  private String salesInstitutionName;

  @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
  @Column(name = "sales_region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
  private String salesRegionCode;

  @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
  @Column(name = "sales_region_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售部门名称'")
  private String salesRegionName;

  @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
  @Column(name = "sales_region_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门erp编码'")
  private String salesRegionErpCode;

  @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
  @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
  private String salesOrgCode;

  @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
  @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
  private String salesOrgName;

  @ApiModelProperty("销售组织erp编码")
  @Column(name = "sales_org_erp_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '销售组织erp编码'")
  private String salesOrgErpCode;

}
