package com.biz.crm.tpm.business.third.system.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * tpm_ztsd_121
 * @ClassName Zmsd121
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/13
 */
@ApiModel(value = "Zmsd121", description = "TPM-费用池余额-121表数据")
@TableName("tpm_zmsd_121")
@Getter
@Setter
@Entity(name = "tpm_zmsd_121")
@org.hibernate.annotations.Table(appliesTo = "tpm_zmsd_121", comment = "TPM-费用池余额-121表数据")
@Table(name = "tpm_zmsd_121", indexes = {
        @Index(name = "tpm_zmsd_121_idx1", columnList = "ds", unique = false),
        @Index(name = "tpm_zmsd_121_idx2", columnList = "customer_code", unique = false),
        @Index(name = "tpm_zmsd_121_idx3", columnList = "sale_org_code", unique = false),
})
@Data
public class Zmsd121 extends TenantFlagOpEntity {

    @ApiModelProperty("客户端")
    @Column(name = "client", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '客户端'")
    private String client;
    @ApiModelProperty("公司代码")
    @Column(name = "company_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '公司代码'")
    private String companyCode;
    @ApiModelProperty("销售组织代码")
    @Column(name = "sale_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '销售组织代码'")
    private String saleOrgCode;
    @ApiModelProperty("产品组")
    @Column(name = "product_team_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '产品组'")
    private String productTeamCode;
    @ApiModelProperty("客户代码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '客户代码'")
    private String customerCode;
    @ApiModelProperty("财年")
    @Column(name = "fiscal_year", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '财年'")
    private String fiscalYear;
    @ApiModelProperty("会计期间")
    @Column(name = "accounting_period", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '会计期间'")
    private String accountingPeriod;
    @ApiModelProperty("物料编号")
    @Column(name = "material_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '物料编号'")
    private String materialCode;
    @ApiModelProperty("期初余额")
    @Column(name = "open_balance", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '期初余额'")
    private BigDecimal openBalance;
    @ApiModelProperty("开票金额")
    @Column(name = "make_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '开票金额'")
    private BigDecimal makeAmount;
    @ApiModelProperty("冻结金额")
    @Column(name = "frozen_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '冻结金额'")
    private BigDecimal frozenAmount;
    @ApiModelProperty("调整转出")
    @Column(name = "adjust_transfer_out", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '调整转出'")
    private BigDecimal adjustTransferOut;
    @ApiModelProperty("扣款金额")
    @Column(name = "deduction_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '扣款金额'")
    private BigDecimal deductionAmount;
    @ApiModelProperty("调整转入")
    @Column(name = "adjust_transfer_in", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '调整转入'")
    private BigDecimal adjustTransferIn;
    @ApiModelProperty("期末余额")
    @Column(name = "ending_balance", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '期末余额'")
    private BigDecimal endingBalance;
    @ApiModelProperty("揉价")
    @Column(name = "knead_price", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '揉价'")
    private BigDecimal kneadPrice;
    @ApiModelProperty("TPM转入金额")
    @Column(name = "tpm_weight", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT 'TPM转入金额'")
    private BigDecimal tpmWeight;
    @ApiModelProperty("货币")
    @Column(name = "currency", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '货币'")
    private String currency;
    @ApiModelProperty("创建人代码")
    @Column(name = "creator_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '创建人代码'")
    private String creatorCode;
    @ApiModelProperty("创建时间")
    @Column(name = "dp_create_time", nullable = true, length = 30, columnDefinition = "varchar(30) COMMENT 'dataphin创建时间'")
    private String dpCreateTime;
    @ApiModelProperty("创建日期")
    @Column(name = "dp_create_date", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT 'dataphin创建日期'")
    private String dpCreateDate;
    @ApiModelProperty("更改人代码")
    @Column(name = "changer_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '更改人代码'")
    private String changerCode;
    @ApiModelProperty("更改时间")
    @Column(name = "change_time", nullable = true, length = 30, columnDefinition = "varchar(30) COMMENT '更改时间'")
    private String changeTime;
    @ApiModelProperty("更改日期")
    @Column(name = "change_date", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '更改日期'")
    private String changeDate;
    @ApiModelProperty("时间分区")
    @Column(name = "ds", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '时间分区'")
    private String ds;

}
