package com.biz.crm.tpm.business.third.system.local.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName Zmsd187
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/13
 */
@ApiModel(value = "Zmsd187", description = "TPM-费用池余额-187表数据")
@TableName("tpm_zmsd_187")
@Getter
@Setter
@Entity(name = "tpm_zmsd_187")
@org.hibernate.annotations.Table(appliesTo = "tpm_zmsd_187", comment = "TPM-费用池余额-187表数据")
@Table(name = "tpm_zmsd_187")
@Data
public class Zmsd187 extends TenantFlagOpEntity {

    @ApiModelProperty("客户端")
    @Column(name = "client", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '客户端'")
    private String client;
    @ApiModelProperty("公司代码")
    @Column(name = "company_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '公司代码'")
    private String companyCode;
    @ApiModelProperty("销售组织代码")
    @Column(name = "sale_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '销售组织代码'")
    private String saleOrgCode;
    @ApiModelProperty("分销渠道")
    @Column(name = "distribution_channel_code", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '分销渠道'")
    private String distributionChannelCode;
    @ApiModelProperty("产品组代码")
    @Column(name = "product_team_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '产品组代码'")
    private String productTeamCode;
    @ApiModelProperty("客户编号")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '客户编号'")
    private String customerCode;
    @ApiModelProperty("销售组")
    @Column(name = "sale_group_code", nullable = true, length = 200, columnDefinition = "varchar(200) COMMENT '销售组'")
    private String saleGroupCode;
    @ApiModelProperty("销售部门")
    @Column(name = "sale_department_code", nullable = true, length = 200, columnDefinition = "varchar(200) COMMENT '销售部门'")
    private String saleDepartmentCode;
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = true, length = 200, columnDefinition = "varchar(200) COMMENT '客户名称'")
    private String customerName;
    @ApiModelProperty("财年")
    @Column(name = "fiscal_year", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '财年'")
    private String fiscalYear;
    @ApiModelProperty("会计期间")
    @Column(name = "accounting_period", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '会计期间'")
    private String accountingPeriod;
    @ApiModelProperty("期初余额")
    @Column(name = "opening_balance", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '期初余额'")
    private BigDecimal openingBalance;
    @ApiModelProperty("TPM转入")
    @Column(name = "tpm_shift", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT 'TPM转入'")
    private BigDecimal tpmShift;
    @ApiModelProperty("开票金额")
    @Column(name = "make_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '开票金额'")
    private BigDecimal makeAmount;
    @ApiModelProperty("转入金额")
    @Column(name = "transfer_in_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '转入金额'")
    private BigDecimal transferInAmount;
    @ApiModelProperty("转出金额")
    @Column(name = "transfer_out_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '转出金额'")
    private BigDecimal transferOutAmount;
    @ApiModelProperty("扣款金额")
    @Column(name = "deduction_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '扣款金额'")
    private BigDecimal deductionAmount;
    @ApiModelProperty("期末余额")
    @Column(name = "ending_balance", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '期末余额'")
    private BigDecimal endingBalance;
    @ApiModelProperty("未扣款金额")
    @Column(name = "not_deducted_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '未扣款金额'")
    private BigDecimal notDeductedAmount;
    @ApiModelProperty("实际费用余额")
    @Column(name = "actual_expense_balance", nullable = true, precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '实际费用余额'")
    private BigDecimal actualExpenseBalance;
    @ApiModelProperty("记录日期")
    @Column(name = "record_date", nullable = true, length = 30, columnDefinition = "varchar(30) COMMENT '记录日期'")
    private String recordDate;
    @ApiModelProperty("简短格式的 UTC 时戳 (YYYYMMDDhhmmss)")
    @Column(name = "timestamp_odps", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '简短格式的 UTC 时戳 (YYYYMMDDhhmmss)'")
    private String timestampOdps;
    @ApiModelProperty("时间分区")
    @Column(name = "ds", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '时间分区'")
    private String ds;

}
