package com.biz.crm.tpm.business.third.system.local.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtExportVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName TpmDailySalesDataExportProcess
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/17
 */
@Component
@Slf4j
public class Ce1MnjtExportProcess implements ExportProcess<Ce1MnjtExportVo> {

    @Autowired(required = false)
    private Ce1MnjtService ce1MnjtService;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Pageable pageable = PageRequest.of(1, 1);
        Page<Ce1MnjtFullVo2> page = this.ce1MnjtService.findDaySalesByConditions(pageable, convertParams(params));
        Integer total = (int) page.getTotal();
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        //分页问题修改
        if (vo.getPageNo() == null) {
            throw new IllegalArgumentException("参数错误");
        }
        vo.setPageNo(vo.getPageNo() + 1);
        Page<Ce1MnjtFullVo2> page = this.ce1MnjtService.findDaySalesByConditions(PageRequest.of(vo.getPageNo(), this.getPageSize()), convertParams(params));
        return JSONArray.parseArray(JSON.toJSONString(page.getRecords()));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_CE1_MNJT_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM_电商日销售数据导出";
    }

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    private Ce1MnjtFullDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
        return JSON.parseObject(JSON.toJSONString(map), Ce1MnjtFullDto.class);
    }
}
