package com.biz.crm.tpm.business.third.system.local.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceExportVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author: yaoyongming
 * @date: 2023/9/9 16:31
 */
@Component
@Slf4j
public class PlatformPriceExportProcess implements ExportProcess<PlatformPriceExportVo> {

    @Autowired(required = false)
    private Ce1MnjtService ce1MnjtService;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(1, 1);
        Ce1MnjtFullDto dto = convertParams(params);
        Page<PlatformPriceVo> pageResult = ce1MnjtService.findPlatformPriceConditions(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        Ce1MnjtFullDto dto = convertParams(params);
        Page<PlatformPriceVo> pageResult = ce1MnjtService.findPlatformPriceConditions(pageable, dto);
        if (CollectionUtils.isEmpty(pageResult.getRecords())) {
            return new JSONArray();
        }
        List<PlatformPriceVo> records = pageResult.getRecords();
        return JSON.parseArray(JSON.toJSONString(records, SerializerFeature.WriteDateUseDateFormat));
    }

    @Override
    public String getBusinessCode() {
        return "PLATFORM_PRICE_EXPORT";
    }

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    /**
     * 获取参数
     *
     * @param params
     * @return
     */
    private Ce1MnjtFullDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), Ce1MnjtFullDto.class);
    }

    @Override
    public String getBusinessName() {
        return "平台价格对比表";
    }
}
