package com.biz.crm.tpm.business.third.system.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVoExportsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @className: Ce1MnjtExportsProcess
 * @description: 电商日销售报表导出
 * @author: hb
 * @create: 2023-03-24 17:07
 */
@Component
public class Ce1MnjtExportsProcess implements ExportProcess<Ce1MnjtFullVoExportsVo> {


    /**
     * 客户key
     */
    private static final String COMPANY_CODE_KEY = "companyCode";

    /**
     * 客户key
     */
    private static final String CUSTOMER_CODE_KEY = "customerCode";

    /**
     * 产品编码key
     */
    private static final String PRODUCT_CODE_KEY = "productCode";

    /**
     * 业态Key
     */
    private static final String PRODUCT_TEAM_CODE_KEY = "productTeamCode";

    @Autowired(required = false)
    private Ce1MnjtService ce1MnjtService;

    @Override
    public Integer getTotal(Map<String, Object> params) {

        Ce1MnjtFullDto ce1MnjtFullDto = createQueryBean(params);

        long totalNumber = ce1MnjtService.findPageTotalByCondition(ce1MnjtFullDto);

        return totalNumber == 0L ? 0 : Integer.valueOf(String.valueOf(totalNumber));
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {

        Ce1MnjtFullDto ce1MnjtFull = createQueryBean(params);

        List<Ce1MnjtFullVoExportsVo> list = this.ce1MnjtService.findExportsByParams(ce1MnjtFull);

        return JSON.parseArray(JSON.toJSONString(list));

    }

    @Override
    public String getBusinessCode() {
        return "ecommerce_daily_sales_data";
    }

    @Override
    public String getBusinessName() {
        return "电商日销售数据SAP导出";
    }

    /**
     * 查询参数
     * @param params
     * @return
     */
    private Ce1MnjtFullDto createQueryBean(Map<String, Object> params) {

        Ce1MnjtFullDto ce1MnjtFullDto = new Ce1MnjtFullDto();

        if (params.containsKey(COMPANY_CODE_KEY)){
            ce1MnjtFullDto.setCompanyCode(String.valueOf(params.get(COMPANY_CODE_KEY)));
        }

        if (params.containsKey(CUSTOMER_CODE_KEY)){
            ce1MnjtFullDto.setCustomerCode(String.valueOf(params.get(CUSTOMER_CODE_KEY)));
        }

        if (params.containsKey(PRODUCT_CODE_KEY)) {
            ce1MnjtFullDto.setProductCode(String.valueOf(params.get(PRODUCT_CODE_KEY)));
        }

        if (params.containsKey(PRODUCT_TEAM_CODE_KEY)){
            ce1MnjtFullDto.setProductTeamCode(String.valueOf(params.get(PRODUCT_TEAM_CODE_KEY)));
        }

        return ce1MnjtFullDto;
    }
}
