package com.biz.crm.tpm.business.third.system.local.job;


import cn.hutool.core.date.DateTime;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Sap099获利能力分析数据表(TpmProfitabilityAnalysis)表服务实现类
 *
 * @author huanglong
 * @date 2023-01-13 12:01:42
 */
@Slf4j
@Service
public class Pull099DataSyncXxlJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;


    @Autowired(required = false)
    private TpmProfitabilityAnalysisService tpmProfitabilityAnalysisService;


    /**
     * 每月3日凌晨3点同步099数据
     */
    @DynamicTaskService(cornExpression = "0 0 3,9,15 3,4,5 * ?", taskDesc = "同步获利能力分析数据(099文档)")
    public void pull099Data() {
        loginUserService.refreshAuthentication(null);
        String yearMonth = DateUtil.format(new DateTime(), "yyyyMM");
        tpmProfitabilityAnalysisService.pull099ByYearMonth(yearMonth, null, null);
    }

}
