package com.biz.crm.tpm.business.third.system.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.local.service.PullFeePoolDataService;
import com.biz.crm.tpm.business.third.system.sdk.constants.FeePoolConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;


/**
 * 会计科目自动更新定时任务     job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class PullFeePoolDataAutoSyncXxlJob {


    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private PullFeePoolDataService pullFeePoolDataService;

    @DynamicTaskService(cornExpression = "0 0 6 2 * ?", taskDesc = "费用池余额自动同步数据187和121")
    public void pullFeePoolData() {
        loginUserService.refreshAuthentication(null);
        //与北极星约定，定时任务取ds为当日-1天  // 2023/08/15 禅道1032634 ds调整为当月1号 ds改成每月1号，对账单取DS月份-1
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        int month = calendar.get(Calendar.MONTH);
        if (month == 0) {
            month = 12;
        }
        String ds = DateUtil.format(calendar.getTime(), FeePoolConstant.DATE_FORMAT);
        String accountingPeriod = String.format("%02d", month);
        log.info("----> 费用池余额自动同步数据187和121 ds[{}] accountingPeriod[{}] start <----", ds, accountingPeriod);
        pullFeePoolDataService.pullFeePoolData(ds, accountingPeriod);
        log.info("----> 费用池余额自动同步数据187和121 ds[{}] accountingPeriod[{}] end <----", ds, accountingPeriod);
    }

}
