package com.biz.crm.tpm.business.third.system.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Ce1MnjtFullVo;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1Mnjt;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVoExportsVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;

import java.math.BigDecimal;
import java.util.List;


/**
 * @Entity com.biz.crm.tpm.business.call.polaris.local.entity.Ce1Mnjt
 */
public interface Ce1MnjtMapper extends BaseMapper<Ce1Mnjt> {

    void saveCe1MnjtEmtityBatch(@Param("ce1MnjtFullVos") List<Ce1MnjtFullVo> ce1MnjtFullVos);

    /**
     * 分页电商日销售数据
     *
     * @param page
     * @param dto
     * @return
     */
    Page<Ce1MnjtFullVo2> findDaySalesByConditions(@Param("page") Page<Ce1MnjtFullVo2> page, @Param("dto") Ce1MnjtFullDto dto);

    /**
     * 电商日销售价格数据
     *
     * @param dto
     * @return
     */
    List<PlatformPriceVo> findDaySalesPriceByConditions(@Param("dto") Ce1MnjtFullDto dto);

    List<Ce1MnjtFullVo2> findExamineCircularDataList(@Param("dto") Ce1ExamineCircularSearchDto dto);

    /**
     * 查询客户在活动时间内销售的产品个数(取过账日期)
     *
     * @param dto
     * @return
     */
    List<Ce1MnjtFullVo2> findProductListByCustomerGroup(@Param("dto") Ce1MnjtSearchDto dto);

    /**
     * 根据id查询数据
     *
     * @param cId
     * @return
     */
    Ce1MnjtFullVo2 findById(@Param("cId") String cId);

    long findPageTotalByCondition(@Param("dto") Ce1MnjtFullDto ce1MnjtFullDto);

    Page<Ce1MnjtFullVo2> findPageByCondition(@Param("page") Page<Ce1MnjtFullVo2> page, @Param("dto") Ce1MnjtFullDto ce1MnjtFullDto);

    BigDecimal getSalesIncludingTaxNetTotal(@Param("ce1MnjtFull") Ce1MnjtFullDto ce1MnjtFull);

    /**
     * 导出数据查询
     *
     * @param ce1MnjtFull 查询参数
     * @return List
     */
    List<Ce1MnjtFullVoExportsVo> findExportsByParams(@Param("ce1Params") Ce1MnjtFullDto ce1MnjtFull);


    List<String> findCe1IdByDs(@Param("ds") String ds);

    Page<Ce1MnjtFullVo2> findDataByPage(@Param("page") Page<Ce1MnjtFullVo2> page, @Param("ds") String ds);

    Page<Ce1MnjtFullVo2> findCe1DataPage(@Param("page") Page<Ce1MnjtFullVo2> page, @Param("codes") List<String> codes, @Param("codeType") Integer codeType);


    Page<Ce1MnjtFullVo2> getMonthSummaryByFinancialYearAndFinancialMonth(Page<Ce1MnjtFullVo2> page, @Param("financialYear") String financialYear, @Param("financialMonth") String financialMonth);

    List<Ce1MnjtFullVo2> findCustomerProductCe1MnjtSumList(@Param("dto") Ce1MnjtSearchDto ce1MnjtSearchDto);

}




