package com.biz.crm.tpm.business.third.system.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.third.system.local.entity.TpmProfitabilityAnalysis;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmZtfi099ForEctQueryDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

/**
 * Sap099获利能力分析数据表(TpmProfitabilityAnalysis)表数据库访问层
 *
 * @author huanglong
 * @date 2023-01-13 12:01:36
 */
public interface TpmProfitabilityAnalysisMapper extends BaseMapper<TpmProfitabilityAnalysis> {


    void batchSave(@Param("list") Collection<TpmProfitabilityAnalysis> list);

    /**
     * 查询099报表 实际理论毛利=实际收入（含税）-实际成本（含税） 条件；发货过账日期+公司代码
     *
     * @param analysisDtos
     * @return
     */
    List<TpmProfitabilityAnalysisVo> findDataSummaryByProfitMonitor(@Param("dtos") List<TpmProfitabilityAnalysisDto> analysisDtos);

    /**
     * ect查询数据
     *
     * @param page
     * @param dto
     * @return
     */
    Page<TpmProfitabilityAnalysisVo> findData4Ect(@Param("page") Page<TpmProfitabilityAnalysisVo> page, @Param("dto") TpmZtfi099ForEctQueryDto dto);

    /**
     * 条件删除
     *
     * @param ds
     * @param yearMonth
     * @param companyCode
     * @param accountDate
     */
    void removeByQuery(@Param("ds") String ds, @Param("yearMonth") String yearMonth, @Param("companyCode") String companyCode, @Param("accountDate") String accountDate);

    BigDecimal computeAmountForProductMergeSaleAmount(@Param("dto") TpmProfitabilityAnalysisDto dto);
}

