package com.biz.crm.tpm.business.third.system.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.account.receivable.sdk.dto.KmsFindZmsd121Dto;
import com.biz.crm.kms.business.account.receivable.sdk.vo.KmsFindZmsd121Vo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.third.system.local.entity.Zmsd121;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmZmsd121Vo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @ClassName Zmsd121Mapper
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/13
 */
public interface Zmsd121Mapper extends BaseMapper<Zmsd121> {
    void saveBatch(List<Zmsd121> entityList);

    void deleteByDs(String ds);

    Page<TpmZmsd121Vo> findByDs(Page<TpmZmsd121Vo> page121,
                                @Param("ds") String ds,
                                @Param("accountingPeriod") String accountingPeriod,
                                @Param("customerVo") CustomerVo customerVo,
                                @Param("salesOrgVo") SalesOrgVo salesOrgVo,
                                @Param("businessFormatCode") String businessFormatCode);

    Integer findTotal(@Param("ds") String ds,
                      @Param("accountingPeriod") String accountingPeriod,
                      @Param("customerVo") CustomerVo customerVo,
                      @Param("salesOrgVo") SalesOrgVo salesOrgVo,
                      @Param("businessFormatCode") String businessFormatCode);
    List<String> findCustomerListByDate(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("customerCode") String customerCode,
                                        @Param("ds") String ds);
    List<TpmZmsd121Vo> findListByDate(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("customerCode") String customerCode,
                                      @Param("ds") String ds);
    /**
     * kms获取121数据
     * @param dto
     * @return
     */
    List<KmsFindZmsd121Vo> findByKmsConditions(@Param("dto") KmsFindZmsd121Dto dto);
}
