package com.biz.crm.tpm.business.third.system.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @ClassName ProfitablilityAnalysisRegister
 * @Description Sap099获利能力分析数据表
 * @AUTHOR WangJJ
 * @DATE 2023/2/22 20:07
 **/
@Component
public class ProfitabilityAnalysisRegister implements DataviewRegister {
    @Override
    public String code() {
        return "profitability_analysis_report";
    }

    @Override
    public String desc() {
        return "TPM-Sap099获利能力分析数据表";
    }

    @Override
    public String buildSql() {
        return " select a.* " +
                "from tpm_profitability_analysis a " +
                "where a.tenant_code = :tenantCode " +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
