package com.biz.crm.tpm.business.third.system.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnLock;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnLockMapper;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnLockDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnLockVo;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Optional;

/**
 * 电商拉取CE日销售数据锁定
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-11-23 10:42
 */
@Component
public class Ce1MnLockRepository extends ServiceImpl<Ce1MnLockMapper, Ce1MnLock> {

    /**
     * 清楚过期数据
     *
     * @return
     */
    public void removeExpireTime() {
        this.lambdaUpdate()
                .le(Ce1MnLock::getExpireTime, new Date())
                .remove();
    }

    public Page<Ce1MnLockVo> findByConditions(Pageable pageable, Ce1MnLockDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new Ce1MnLockDto());
        Page<Ce1MnLockVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findByConditions(page, dto);
    }

}
