package com.biz.crm.tpm.business.third.system.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.third.system.local.entity.TpmProfitabilityAnalysis;
import com.biz.crm.tpm.business.third.system.local.mapper.TpmProfitabilityAnalysisMapper;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmZtfi099ForEctQueryDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * Sap099获利能力分析数据表(repository)
 *
 * @author huanglong
 * @date 2023-01-13 12:01:39
 */
@Component
public class TpmProfitabilityAnalysisRepository extends ServiceImpl<TpmProfitabilityAnalysisMapper, TpmProfitabilityAnalysis> {
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional(rollbackFor = Exception.class, propagation = Propagation.NOT_SUPPORTED)
    public void batchSave(Collection<TpmProfitabilityAnalysis> list) {
        this.baseMapper.batchSave(list);
    }

    public List<TpmProfitabilityAnalysisVo> listForVariable(TpmProfitabilityAnalysisDto dto) {
        if (StringUtils.isEmpty(dto.getCompanyCode())
                && StringUtils.isEmpty(dto.getSpartCode())
                && StringUtils.isEmpty(dto.getAccountDateBegin())
                && StringUtils.isEmpty(dto.getAccountDateEnd())
                && StringUtils.isEmpty(dto.getServiceCode())
                && StringUtils.isEmpty(dto.getChannelCode())
                && StringUtils.isEmpty(dto.getBrandCode())
                && StringUtils.isEmpty(dto.getCategoryCode())
                && StringUtils.isEmpty(dto.getItemCode())
                && CollectionUtils.isEmpty(dto.getMaterialCodes())
                && CollectionUtils.isEmpty(dto.getExcludeMaterialCodes())
                && CollectionUtils.isEmpty(dto.getExcludeBrandCodes())
                && CollectionUtils.isEmpty(dto.getExcludeCategoryCodes())
                && CollectionUtils.isEmpty(dto.getExcludeItemCodes())
                && CollectionUtils.isEmpty(dto.getIncludeServiceCodes())
        ) {
            return Lists.newArrayList();
        }
        List<TpmProfitabilityAnalysis> list = this.lambdaQuery()
                .eq(TpmProfitabilityAnalysis::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(StringUtils.isNotEmpty(dto.getCompanyCode()), TpmProfitabilityAnalysis::getCompanyCode, dto.getCompanyCode())
                .eq(StringUtils.isNotEmpty(dto.getSpartCode()), TpmProfitabilityAnalysis::getSpartCode, dto.getSpartCode())
                .eq(StringUtils.isNotEmpty(dto.getServiceCode()), TpmProfitabilityAnalysis::getServiceCode, dto.getServiceCode())
                .eq(StringUtils.isNotEmpty(dto.getChannelCode()), TpmProfitabilityAnalysis::getChannelCode, dto.getChannelCode())
                .eq(StringUtils.isNotEmpty(dto.getBrandCode()), TpmProfitabilityAnalysis::getBrandCode, dto.getBrandCode())
                .eq(StringUtils.isNotEmpty(dto.getCategoryCode()), TpmProfitabilityAnalysis::getCategoryCode, dto.getCategoryCode())
                .eq(StringUtils.isNotEmpty(dto.getItemCode()), TpmProfitabilityAnalysis::getItemCode, dto.getItemCode())
                .in(CollectionUtils.isNotEmpty(dto.getMaterialCodes()), TpmProfitabilityAnalysis::getMaterialCode, dto.getMaterialCodes())
                .in(CollectionUtils.isNotEmpty(dto.getIncludeServiceCodes()), TpmProfitabilityAnalysis::getServiceCode, dto.getIncludeServiceCodes())
                .notIn(CollectionUtils.isNotEmpty(dto.getExcludeMaterialCodes()), TpmProfitabilityAnalysis::getMaterialCode, dto.getExcludeMaterialCodes())
                .notIn(CollectionUtils.isNotEmpty(dto.getExcludeBrandCodes()), TpmProfitabilityAnalysis::getBrand, dto.getExcludeBrandCodes())
                .notIn(CollectionUtils.isNotEmpty(dto.getExcludeCategoryCodes()), TpmProfitabilityAnalysis::getCategoryCode, dto.getExcludeCategoryCodes())
                .notIn(CollectionUtils.isNotEmpty(dto.getExcludeItemCodes()), TpmProfitabilityAnalysis::getItemCode, dto.getExcludeItemCodes())
                .between(StringUtils.isNotEmpty(dto.getAccountDateBegin()) && StringUtils.isNotEmpty(dto.getAccountDateEnd()), TpmProfitabilityAnalysis::getAccountDate, dto.getAccountDateBegin(), dto.getAccountDateEnd())
                .list();
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<TpmProfitabilityAnalysisVo>) nebulaToolkitService.copyCollectionByWhiteList(list, TpmProfitabilityAnalysis.class, TpmProfitabilityAnalysisVo.class, HashSet.class, ArrayList.class);
    }

    public Page<TpmProfitabilityAnalysisVo> findData4Ect(Pageable pageable, TpmZtfi099ForEctQueryDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        Page<TpmProfitabilityAnalysisVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmProfitabilityAnalysisVo> pageList = this.baseMapper.findData4Ect(page, dto);
        if (pageList == null) {
            return new Page<TpmProfitabilityAnalysisVo>();
        }
        return pageList;
    }

    /**
     * 查询099报表 实际理论毛利=实际收入（含税）-实际成本（含税） 条件；发货过账日期+公司代码
     *
     * @param analysisDtos
     * @return
     */
    public List<TpmProfitabilityAnalysisVo> findDataSummaryByProfitMonitor(List<TpmProfitabilityAnalysisDto> analysisDtos) {
        return this.baseMapper.findDataSummaryByProfitMonitor(analysisDtos);
    }

    public void removeByQuery(String ds, String yearMonth, String companyCode, String accountDate) {
        if (StringUtil.isEmpty(ds)
                || StringUtil.isEmpty(yearMonth)) {
            return;
        }
        this.baseMapper.removeByQuery(ds, yearMonth, companyCode, accountDate);
    }

    public BigDecimal computeAmountForProductMergeSaleAmount(TpmProfitabilityAnalysisDto dto) {
        if(Objects.isNull(dto)){
            return BigDecimal.ZERO;
        }
        return this.baseMapper.computeAmountForProductMergeSaleAmount(dto);
    }
}
