package com.biz.crm.tpm.business.third.system.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Ce1MnjtFullVo;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1Mnjt;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVoExportsVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;


/**
 *
 */
public interface Ce1MnjtService extends IService<Ce1Mnjt> {

    /**
     * 保存电商日销售数据
     *  @param ce1MnjtDatas
     *  @param ds
     *
     */
    void saveEntityBatch(List<Ce1MnjtFullVo> ce1MnjtDatas,String ds);

    /**
     * 电商日销售报表
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<Ce1MnjtFullVo2> findDaySalesByConditions(Pageable pageable, Ce1MnjtFullDto dto);

    /**
     * 分页查询平台价格对比报表
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<PlatformPriceVo> findPlatformPriceConditions(Pageable pageable, Ce1MnjtFullDto dto);


    /**
     * 根据id查询日销售数据
     *
     * @param ids
     * @return
     */
    List<Ce1MnjtFullVo2> findDataByIds(List<String> ids);

    Page<Ce1MnjtFullVo2> findDataPage(Pageable pageable, String ds);

    List<Ce1MnjtFullVo2> findCe1DataByCode(Page<Ce1MnjtFullVo2> page, List<String> codes, Integer codeType);

    Integer getTotalNumber(List<String> codes, Integer codeType);

    /**
     * 考勤通报管理查询分摊数据
     *
     * @param dto
     * @return
     */
    List<Ce1ExamineCircularSearchVo> findExamineCircularDataList(Ce1ExamineCircularSearchDto dto, String cacheKey);

    /**
     * 根据客户编码及时间查询
     *
     * @param customerCode 客户编码
     * @param dateList     时间
     * @return List
     */
    List<Ce1MnjtFullVo2> findDataByCustomerCodeAndDate(String customerCode, String productCode, List<String> dateList);

    /**
     * 条件查询
     *
     * @param dto
     * @return
     */
    List<Ce1MnjtFullVo2> findListByCondition(Ce1MnjtFullDto dto);

    /**
     * 查询客户在活动时间内销售的产品个数(取过账日期)
     *
     * @param dto
     * @return
     */
    List<Ce1MnjtFullVo2> findProductListByCustomerGroup(Ce1MnjtSearchDto dto);

    long findPageTotalByCondition(Ce1MnjtFullDto ce1MnjtFullDto);

    Page<Ce1MnjtFullVo2> findPageByCondition(Page<Ce1MnjtFullVo2> page, Ce1MnjtFullDto ce1MnjtFullDto);

    /**
     * 查询总额
     *
     * @param ce1MnjtFull
     * @return
     */
    BigDecimal getSalesIncludingTaxNetTotal(Ce1MnjtFullDto ce1MnjtFull);

    /**
     * 导出数据查询
     *
     * @param ce1MnjtFull 查询参数
     * @return List
     */
    List<Ce1MnjtFullVoExportsVo> findExportsByParams(Ce1MnjtFullDto ce1MnjtFull);

    List<String> findCe1ByDs(String ds);

    void deleteCe1(String ds);

    Integer getCe1MnjtTotal(String ds);
}
