package com.biz.crm.tpm.business.third.system.local.service;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;

/**
 * 拉取费用池信息
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-08-16 17:52
 */
public interface PullFeePoolDataService {
    /**
     * 异步拉取费用池余额
     *
     * @param ds
     * @param accountingPeriod
     * @param userIdentity
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-08-16 17:45
     */
    void pullFeePoolDataAsync(String ds, String accountingPeriod, AbstractCrmUserIdentity userIdentity);

    /**
     * 异步拉取费用池余额
     *
     * @param ds
     * @param accountingPeriod
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-08-16 17:45
     */
    void pullFeePoolData(String ds, String accountingPeriod);

}
