package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.third.system.a.pallet.goods.dto.APalletGoodsTransferDto;
import com.biz.crm.mn.third.system.a.pallet.goods.service.APalletGoodsTransferService;
import com.biz.crm.tpm.business.third.system.local.entity.APalletGoods;
import com.biz.crm.tpm.business.third.system.local.repository.APalletGoodsRepository;
import com.biz.crm.tpm.business.third.system.sdk.dto.APalletGoodsDto;
import com.biz.crm.tpm.business.third.system.sdk.service.APalletGoodsService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author liyang
 * @date 2024/04/09
 */
@Slf4j
@Service
public class APalletGoodsServiceImpl implements APalletGoodsService {

  @Autowired(required = false)
  private APalletGoodsRepository aPalletGoodsRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private APalletGoodsTransferService aPalletGoodsTransferService;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void feeAdjustApply(APalletGoodsTransferDto<APalletGoodsDto> dto) {
    log.info("APalletGoodsServiceImpl:feeAdjustApply{}", JSON.toJSONString(dto));
    Validate.notNull(dto, "传入数据空");
    Validate.notEmpty(dto.getItemList(), "传入数据空");
    // 解析接收的数据
    if (CollectionUtils.isNotEmpty(dto.getItemList())) {
      Collection<APalletGoods> list = nebulaToolkitService.copyCollectionByWhiteList(dto.getItemList(), APalletGoodsDto.class, APalletGoods.class, HashSet.class, ArrayList.class);
      list = list.stream().peek(e -> {
        e.setTenantCode(TenantUtils.getTenantCode());
        e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      }).collect(Collectors.toList());
      aPalletGoodsRepository.saveBatch(list);
    }
  }

  @Override
  public void adjustStatusFeedback(APalletGoodsDto aPalletGoodsDto) {
    APalletGoodsTransferDto<APalletGoodsDto> dto = new APalletGoodsTransferDto<>();
    dto.setItemList(Lists.newArrayList(aPalletGoodsDto));
    aPalletGoodsTransferService.adjustStatusFeedback(dto);
  }
}
