package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnLock;
import com.biz.crm.tpm.business.third.system.local.repository.Ce1MnLockRepository;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnLockService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnLockDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnLockVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;

/**
 * 电商拉取CE日销售数据锁定 service 实现
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-11-23 10:44
 */
@Service
@Slf4j
public class Ce1MnLockServiceImpl implements Ce1MnLockService {

    @Autowired(required = false)
    private Ce1MnLockRepository ce1MnLockRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 分页查询
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnLockVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-23 10:58
     */
    @Override
    public Page<Ce1MnLockVo> findByConditions(Pageable pageable, Ce1MnLockDto dto) {
        return ce1MnLockRepository.findByConditions(pageable, dto);
    }


    /**
     * 新启事务,保存或更新数据
     *
     * @param vo
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-23 12:03
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
    public void saveOrUpdateNewTransactional(Ce1MnLockVo vo) {
        Assert.notNull(vo, "数据不能不为空");
        Assert.hasLength(vo.getDs(), "时间分区[ds]不能为空");
        if (Objects.isNull(vo.getExpireTime())) {
            //过期时间一天
            Date expireTime = DateUtil.dateAddDay(new Date(), 1);
            vo.setExpireTime(expireTime);
        }
        vo.setRetryTime(Optional.ofNullable(vo.getRetryTime()).orElse(0));
        vo.setCurrentPageNumber(Optional.ofNullable(vo.getCurrentPageNumber()).orElse(0));
        Ce1MnLock entity = nebulaToolkitService.copyObjectByWhiteList(vo, Ce1MnLock.class, HashSet.class, ArrayList.class);
        ce1MnLockRepository.saveOrUpdate(entity);

    }
}
