package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnjtInfo;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtInfoMapper;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtMapper;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtInfoService;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description: 电商日销售数据
 * @Author: dengwei
 * @Date: 2023/2/14 20:13
 * @Version: 1.0
 */
@Service
@Slf4j
public class Ce1MnjtSdkServiceImpl implements Ce1MnjtSdkService {

    @Autowired(required = false)
    private Ce1MnjtService ce1MnjtService;

    @Autowired(required = false)
    private Ce1MnjtInfoService ce1MnjtInfoService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private Ce1MnjtMapper ce1MnjtMapper;

    @Autowired(required = false)
    private Ce1MnjtInfoMapper ce1MnjtInfoMapper;

    @Override
    public List<Ce1MnjtFullVo2> findDataByIds(List<String> ids) {

        return ce1MnjtService.findDataByIds(ids);
    }

    @Override
    public List<Ce1MnjtFullVo2> findCe1DataByCodes(Page<Ce1MnjtFullVo2> page, List<String> verifyCodes, Integer codeType) {

        return this.ce1MnjtService.findCe1DataByCode(page, verifyCodes, codeType);
    }

    @Override
    public Page<Ce1MnjtFullVo2> findDataPage(Pageable pageable, String ds) {
        return this.ce1MnjtService.findDataPage(pageable, ds);
    }

    @Override
    public Integer getCeqMnjtTotal(String ds) {
        return this.ce1MnjtService.getCe1MnjtTotal(ds);
    }

    @Override
    public List<Ce1MnjtFullVo2> findDataByCustomerCodeAndDatas(String customerCode, String productCode, List<String> datas) {
        return ce1MnjtService.findDataByCustomerCodeAndDate(customerCode, productCode, datas);
    }

    @Override
    public List<Ce1MnjtFullVo2> findListByCondition(Ce1MnjtFullDto dto) {
        if(Objects.nonNull(dto)) {
            return ce1MnjtService.findListByCondition(dto);
        }
        return Lists.newArrayList();
    }

    @Override
    public long findPageTotalByCondition(Ce1MnjtFullDto ce1MnjtFullDto) {
        return ce1MnjtService.findPageTotalByCondition(ce1MnjtFullDto);
    }

    @Override
    public Page<Ce1MnjtFullVo2> findPageByCondition(Page<Ce1MnjtFullVo2> page, Ce1MnjtFullDto ce1MnjtFullDto) {

        Page<Ce1MnjtFullVo2> pageResult = ce1MnjtService.findPageByCondition(page, ce1MnjtFullDto);
        if(CollectionUtils.isNotEmpty(pageResult.getRecords())){
            List<String> cids = pageResult.getRecords().stream().map(Ce1MnjtFullVo2::getCId).collect(Collectors.toList());
            List<Ce1MnjtFullVo2> infoList = ce1MnjtInfoService.findByCids(cids);
            Map<String, Ce1MnjtFullVo2> infoMap = infoList.stream().collect(Collectors.toMap(Ce1MnjtFullVo2::getTpmCe1MnjtId, Function.identity()));
            for (Ce1MnjtFullVo2 record : pageResult.getRecords()) {
                Ce1MnjtFullVo2 ce1MnjtFullVo2 = infoMap.get(record.getCId());
                record.setSalesIncludingTaxNet(ce1MnjtFullVo2.getSalesIncludingTaxNet());
            }
        }
        return pageResult;
    }

    @Override
    public List<Ce1ExamineCircularSearchVo> findExamineCircularDataList(Ce1ExamineCircularSearchDto dto, String cacheKey) {
        if (StringUtils.isNotEmpty(dto.getStartDate()) && StringUtils.isNotEmpty(dto.getEndDate())) {
            Validate.isTrue(StringUtils.equals(dto.getStartDate().substring(0, 7), dto.getEndDate().substring(0, 7)), "查询时间不能跨月！");
        }

        cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey;
        if (StringUtils.isNotEmpty(cacheKey)) {
            redisService.del(cacheKey);
        }
        if (StringUtils.isEmpty(dto.getSaleOrgCode())
                || StringUtils.isEmpty(dto.getCustomerCode())
                || StringUtils.isEmpty(dto.getStartDate())
                || StringUtils.isEmpty(dto.getEndDate())) {
            return org.apache.commons.compress.utils.Lists.newArrayList();
        }
        //用的MDG客户编码查询
        List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(com.google.common.collect.Lists.newArrayList(dto.getCustomerCode()));
        Validate.notEmpty(customerVos, "客户编码[%s]客户信息不存在！", dto.getCustomerCode());

        //销售公司
        List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllParentBySalesOrgCode(dto.getSaleOrgCode());
        salesOrgVos = salesOrgVos.stream().filter(e -> StringUtils.equals(SalesOrgLevelTypeEnum.MECHANISM.getCode(), e.getSalesOrgLevel())).collect(Collectors.toList());
        Validate.notEmpty(salesOrgVos, "销售组织编码[%s]，未查询到销售公司！", dto.getSaleOrgCode());
        String companyCode = salesOrgVos.get(0).getErpCode();

        dto.setSaleOrgCode(companyCode);
        dto.setCustomerCode(customerVos.get(0).getErpCode());
        dto.setStartDate(dto.getStartDate().replaceAll("-", ""));
        dto.setEndDate(dto.getEndDate().replaceAll("-", ""));
        List<Ce1MnjtFullVo2> dataList = this.ce1MnjtMapper.findExamineCircularDataList(dto);

        //数据处理
        List<Ce1ExamineCircularSearchVo> list = new ArrayList<>();
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(dataList)) {
            List<String> productCodeList = dataList.stream().map(Ce1MnjtFullVo2::getProductCode).distinct().collect(Collectors.toList());
            List<ProductVo> productVoList = productVoService.findMainDetailsByProductCodes(productCodeList);
            Map<String, ProductVo> productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2));

            List<String> idList = dataList.stream().flatMap(o -> Arrays.stream(o.getCids().split(","))).collect(Collectors.toList());
            List<Ce1MnjtInfo> ce1Infos = this.ce1MnjtInfoMapper.selectList(Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, idList));
            Map<String, Ce1MnjtInfo> ce1InfoMap = ce1Infos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
            //含税销售额(净额)
            BigDecimal salesIncludingTaxNet = BigDecimal.ZERO;
            for (Ce1MnjtFullVo2 v : dataList) {
                String[] idArr = v.getCids().split(",");
                for (String id : idArr) {
                    Ce1MnjtInfo ce1MnjtInfo = ce1InfoMap.get(id);
                    if (ce1MnjtInfo != null && Objects.nonNull(ce1MnjtInfo.getSalesIncludingTaxNet())) {
                        salesIncludingTaxNet = salesIncludingTaxNet.add(new BigDecimal(ce1MnjtInfo.getSalesIncludingTaxNet()));
                    }
                }
                Ce1ExamineCircularSearchVo searchVo = new Ce1ExamineCircularSearchVo();
                searchVo.setProductCode(v.getProductCode());
                if (productMap.containsKey(v.getProductCode())) {
                    ProductVo productVo = productMap.get(v.getProductCode());
                    searchVo.setProductName(productVo.getProductName());
                    searchVo.setProductBrandCode(productVo.getProductBrandCode());
                    searchVo.setProductBrandName(productVo.getProductBrandName());
                    searchVo.setProductLevelCode(productVo.getProductCategoryCode());
                    searchVo.setProductLevelName(productVo.getProductCategoryName());
                    searchVo.setSubProductLevelCode(productVo.getProductLevelCode());
                    searchVo.setSubProductLevelName(productVo.getProductLevelName());
                }
                searchVo.setSplitAmount(salesIncludingTaxNet);
                searchVo.setProductCode(searchVo.getProductCode());
                list.add(searchVo);
            }
        }
        list = list.stream().filter(e->Objects.nonNull(e.getSplitAmount()) && BigDecimal.ZERO.compareTo(e.getSplitAmount()) < 0).collect(Collectors.toList());
        //均摊计算用
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list) && StringUtils.isNotEmpty(cacheKey)) {
            Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(Ce1ExamineCircularSearchVo::getProductCode, Ce1ExamineCircularSearchVo::getSplitAmount, (v1, v2) -> v2));
            redisService.set(cacheKey, JSONObject.toJSONString(map), 60 * 60 * 12);
        }
        return list;
    }

    @Override
    public BigDecimal getSalesIncludingTaxNetTotal(Ce1MnjtFullDto ce1MnjtFull) {
        return this.ce1MnjtService.getSalesIncludingTaxNetTotal(ce1MnjtFull);
    }

    @Override
    public Integer getTotalNumber(List<String> codes, Integer codeType) {
        return this.ce1MnjtService.getTotalNumber(codes, codeType);
    }

    @Override
    public Page<Ce1MnjtFullVo2> getMonthSummaryByFinancialYearAndFinancialMonth(Pageable pageable, String financialYear, String financialMonth) {
        Page<Ce1MnjtFullVo2> page =new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        return this.ce1MnjtMapper.getMonthSummaryByFinancialYearAndFinancialMonth(page, financialYear, financialMonth);
    }

    @Override
    public Page<Ce1MnjtFullVo2> findSalesByConditions(Pageable pageable, Ce1MnjtFullDto dto) {
        return this.ce1MnjtService.findDaySalesByConditions(pageable,dto);
    }

    @Override
    public List<Ce1MnjtFullVo2> findCustomerProductCe1MnjtSumList(Ce1MnjtSearchDto ce1MnjtSearchDto) {
        return this.ce1MnjtMapper.findCustomerProductCe1MnjtSumList(ce1MnjtSearchDto);
    }
}
