package com.biz.crm.tpm.business.third.system.local.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Ce1MnjtFullVo;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1Mnjt;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnjtCostDis;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnjtInfo;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtCostDisMapper;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtInfoMapper;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtMapper;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.InvoiceTypeEnum;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVoExportsVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 */
@Service
@Slf4j
public class Ce1MnjtServiceImpl extends ServiceImpl<Ce1MnjtMapper, Ce1Mnjt> implements Ce1MnjtService {

    @Autowired(required = false)
    private Ce1MnjtMapper ce1MnjtMapper;

    @Autowired(required = false)
    private Ce1MnjtInfoMapper ce1MnjtInfoMapper;

    @Autowired(required = false)
    private Ce1MnjtCostDisMapper ce1MnjtCostDisMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private PriceModelVoService priceModelVoService;

    /**
     * 保存电商日销售数据
     *
     * @param list
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-19 14:15
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
    public void saveEntityBatch(List<Ce1MnjtFullVo> list, String ds) {

        list.forEach(vo -> {
            vo.setCId(UuidCrmUtil.general());
            //拼接crm客户编码
            String crmCustomerCode = vo.getCustomerCode() + vo.getSaleOrgCode() + vo.getDistributionChannelCode() + vo.getProductTeamCode();
            vo.setCrmCustomerCode(crmCustomerCode);
            vo.setVerifyCode(vo.getVerifyCodeOnly());
        });

        //根据唯一维度查询
        List<String> verifyCodeList = list.stream().map(Ce1MnjtFullVo::getVerifyCodeOnly).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(verifyCodeList)) {
            List<Ce1Mnjt> verifyCe1MnjtList = this.ce1MnjtMapper
                    .selectList(Wrappers.lambdaQuery(Ce1Mnjt.class)
                            .in(Ce1Mnjt::getVerifyCode, verifyCodeList));
            this.ce1MnjtMapper.delete(Wrappers.lambdaQuery(Ce1Mnjt.class)
                    .in(Ce1Mnjt::getVerifyCode, verifyCodeList).eq(Ce1Mnjt::getDs, ds));
            if (CollUtil.isNotEmpty(verifyCe1MnjtList)) {
                List<String> cIds = verifyCe1MnjtList.stream()
                        .map(Ce1Mnjt::getCId).collect(Collectors.toList());
                this.ce1MnjtInfoMapper.delete(Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, cIds));
                this.ce1MnjtCostDisMapper.delete(Wrappers.lambdaQuery(Ce1MnjtCostDis.class).in(Ce1MnjtCostDis::getTpmCe1Id, cIds));
            }
        }
        this.ce1MnjtMapper.saveCe1MnjtEmtityBatch(list);
        this.ce1MnjtInfoMapper.saveCe1MnjtEmtityBatch(list);
        this.ce1MnjtCostDisMapper.saveCe1MnjtEmtityBatch(list);

    }

    @Override
    public Page<Ce1MnjtFullVo2> findDaySalesByConditions(Pageable pageable, Ce1MnjtFullDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new Ce1MnjtFullDto();
        }
        Page<Ce1MnjtFullVo2> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (StringUtils.isNotBlank(dto.getDocumentCreatDateStart())) {
            dto.setDocumentCreatDateStart(dto.getDocumentCreatDateStart().replace("-", ""));
        }
        if (StringUtils.isNotBlank(dto.getDocumentCreatDateEnd())) {
            dto.setDocumentCreatDateEnd(dto.getDocumentCreatDateEnd().replace("-", ""));
        }
        LocalDate localDate = LocalDate.now();
        String postDateEnd = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        localDate = localDate.plusDays(-7);
        String postDateStart = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        //过账日期默认查询7天
        if (StringUtils.isNotBlank(dto.getPostDateStart())) {
            dto.setPostDateStart(dto.getPostDateStart().replace("-", ""));
        } else {
            if (StringUtil.isEmpty(dto.getYearMonth())) {
                dto.setPostDateStart(postDateStart);
            }
        }
        if (StringUtils.isNotBlank(dto.getPostDateEnd())) {
            dto.setPostDateEnd(dto.getPostDateEnd().replace("-", ""));
        } else {
            if (StringUtil.isEmpty(dto.getYearMonth())) {
                dto.setPostDateEnd(postDateEnd);
            }
        }
        Page<Ce1MnjtFullVo2> ce1MnjtFullVoPage = this.ce1MnjtMapper.findDaySalesByConditions(page, dto);
        List<Ce1MnjtFullVo2> records = ce1MnjtFullVoPage.getRecords();
        if (CollectionUtils.isNotEmpty(records)) {
            for (int i = 0; i < records.size(); i++) {
                String cId = records.get(i).getCId();
                String cIds = records.get(i).getCids();
                if (StringUtils.isNotBlank(cId)) {
                    records.set(i, ce1MnjtMapper.findById(cId));
                    records.get(i).setCids(cIds);
                }
            }
            List<String> ids = records.stream().flatMap(o -> Arrays.stream(o.getCids().split(","))).collect(Collectors.toList());
            List<Ce1MnjtInfo> ce1MnjtInfos = this.ce1MnjtInfoMapper.selectList(Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, ids));
            Map<String, Ce1MnjtInfo> ce1MnjtInfoMap = ce1MnjtInfos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
            buildResult(records, ce1MnjtInfoMap, null);
        }
        return ce1MnjtFullVoPage;
    }

    /**
     * 分页查询平台价格对比报表
     *
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<PlatformPriceVo> findPlatformPriceConditions(Pageable pageable, Ce1MnjtFullDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        String yearMonth;
        if (StringUtils.isBlank(dto.getYearMonth())) {
            yearMonth = DateUtil.format(new Date(), "yyyyMM");
        } else {
            yearMonth = dto.getYearMonth().replace("-", "");
        }
        dto.setYearMonth(yearMonth);

        //Page<PlatformPriceVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        log.info("平台价格表查询参数:{}", JSON.toJSONString(dto));
        List<PlatformPriceVo> records = ce1MnjtMapper.findDaySalesPriceByConditions(dto);
        if (CollectionUtils.isEmpty(records)) {
            return new Page<>();
        }

        Set<String> customerCodeSet = new HashSet<>();
        Set<String> productCodeSet = new HashSet<>();

        records.forEach(e -> {
            productCodeSet.add(e.getProductCode());
            String crmCustomerCode = e.getCustomerCode() + e.getSaleOrgCode() + e.getDistributionChannelCode() + e.getProductTeamCode();
            customerCodeSet.add(crmCustomerCode);
            e.setCrmCustomerCode(crmCustomerCode);
        });

        List<ProductVo> productVos = productVoService.findByCodes(new ArrayList<>(productCodeSet));
        Map<String, String> productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductName));
        List<CustomerVo> customerVoList = customerVoService.findBaseByCustomerCodes(new ArrayList<>(customerCodeSet));
        Map<String, String> estorePlatformMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, e -> StringUtils.defaultIfBlank(e.getEstorePlatform(), "")));

        LinkedHashMap<String, Map<String, List<PlatformPriceVo>>> map = records.stream().collect(Collectors.groupingBy(PlatformPriceVo::getProductCode, LinkedHashMap::new, Collectors.groupingBy(PlatformPriceVo::getCrmCustomerCode)));

        //标准零售价
        SearchPriceDto searchPriceDto = new SearchPriceDto();
        searchPriceDto.setPriceTypeCode(PriceTypeEnum.STANDARD_RETAIL_PRICE.getDictCode());
        List<SearchPriceDimensionItemDto> itemDtos = new ArrayList<>();
        SearchPriceDimensionItemDto dimensionItemDto1 = new SearchPriceDimensionItemDto();
        dimensionItemDto1.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
        dimensionItemDto1.setRelateCodeSet(map.keySet());
        itemDtos.add(dimensionItemDto1);
        searchPriceDto.setDimensionItems(itemDtos);

        Map<String, PriceModelVo> standardRetailPrice = priceModelVoService.handleSearchPrice(searchPriceDto);
        log.info("标准零售价查询结果,{}", JSON.toJSONString(standardRetailPrice));
        List<PlatformPriceVo> resultList = new ArrayList<>();
        for (String k : map.keySet()) {
            Map<String, List<PlatformPriceVo>> listMap = map.get(k);
            BigDecimal tmallChaoshiV = BigDecimal.ZERO;
            BigDecimal jdDeluxuV = BigDecimal.ZERO;
            BigDecimal distributionV = BigDecimal.ZERO;
            BigDecimal jdPopV = BigDecimal.ZERO;
            BigDecimal expandBusinessDepartmentV = BigDecimal.ZERO;
            BigDecimal tmallV = BigDecimal.ZERO;
            BigDecimal pddV = BigDecimal.ZERO;
            BigDecimal contentMarketingV = BigDecimal.ZERO;
            BigDecimal communityV = BigDecimal.ZERO;
            BigDecimal factoryV = BigDecimal.ZERO;
            BigDecimal jdMarketV = BigDecimal.ZERO;
            BigDecimal tmallChaoshiA = BigDecimal.ZERO;
            BigDecimal jdDeluxuA = BigDecimal.ZERO;
            BigDecimal distributionA = BigDecimal.ZERO;
            BigDecimal jdPopA = BigDecimal.ZERO;
            BigDecimal expandBusinessDepartmentA = BigDecimal.ZERO;
            BigDecimal tmallA = BigDecimal.ZERO;
            BigDecimal pddA = BigDecimal.ZERO;
            BigDecimal contentMarketingA = BigDecimal.ZERO;
            BigDecimal communityA = BigDecimal.ZERO;
            BigDecimal factoryA = BigDecimal.ZERO;
            BigDecimal jdMarketA = BigDecimal.ZERO;

            for (String k2 : listMap.keySet()) {
                String estorePlatformCode = estorePlatformMap.get(k2);
                //1. 在该年月的日销售数据中，对有销售数据的客户进行判断，若该客户在主数据中未维护电商平台则不参与计算。
                if (StringUtils.isBlank(estorePlatformCode)) {
                    continue;
                }

                BigDecimal salesVolumes = BigDecimal.ZERO;
                BigDecimal salesTaxAmount = BigDecimal.ZERO;
                List<PlatformPriceVo> platformPriceVos = listMap.get(k2);
                for (PlatformPriceVo vo : platformPriceVos) {
                    salesVolumes = salesVolumes.add(vo.getSalesVolumes());
                    salesTaxAmount = salesTaxAmount.add(vo.getSalesTaxAmount());
                }
                switch (estorePlatformCode) {
                    case "tmall":
                        tmallChaoshiV = tmallChaoshiV.add(salesVolumes);
                        tmallChaoshiA = tmallChaoshiA.add(salesTaxAmount);
                        break;
                    case "jdtls":
                        jdDeluxuV = jdDeluxuV.add(salesVolumes);
                        jdDeluxuA = jdDeluxuA.add(salesTaxAmount);
                        break;
                    case "onlinedistribution":
                        distributionV = distributionV.add(salesVolumes);
                        distributionA = distributionA.add(salesTaxAmount);
                        break;
                    case "jdpopd":
                        jdPopV = jdPopV.add(salesVolumes);
                        jdPopA = jdPopA.add(salesTaxAmount);
                        break;
                    case "tzywb":
                        expandBusinessDepartmentV = expandBusinessDepartmentV.add(salesVolumes);
                        expandBusinessDepartmentA = expandBusinessDepartmentA.add(salesTaxAmount);
                        break;
                    case "tmall2":
                        tmallV = tmallV.add(salesVolumes);
                        tmallA = tmallA.add(salesTaxAmount);
                        break;
                    case "pinduoduo":
                        pddV = pddV.add(salesVolumes);
                        pddA = pddA.add(salesTaxAmount);
                        break;
                    case "nryx":
                        contentMarketingV = contentMarketingV.add(salesVolumes);
                        contentMarketingA = contentMarketingA.add(salesTaxAmount);
                        break;
                    case "sqtg":
                        communityV = communityV.add(salesVolumes);
                        communityA = communityA.add(salesTaxAmount);
                        break;
                    case "gczy":
                        factoryV = factoryV.add(salesVolumes);
                        factoryA = factoryA.add(salesTaxAmount);
                        break;
                    case "jingdong":
                        jdMarketV = jdMarketV.add(salesVolumes);
                        jdMarketA = jdMarketA.add(salesTaxAmount);
                        break;
                    default:
                        break;
                }
            }

            PlatformPriceVo resultVo = new PlatformPriceVo();
            resultVo.setProductCode(k);
            resultVo.setProductName(productMap.get(k));
            resultVo.setYearMonth(yearMonth);
            resultVo.setTmallChaoshi(BigDecimal.ZERO);
            resultVo.setJdDeluxu(BigDecimal.ZERO);
            resultVo.setDistribution(BigDecimal.ZERO);
            resultVo.setJdPop(BigDecimal.ZERO);
            resultVo.setExpandBusinessDepartment(BigDecimal.ZERO);
            resultVo.setTmall(BigDecimal.ZERO);
            resultVo.setPdd(BigDecimal.ZERO);
            resultVo.setContentMarketing(BigDecimal.ZERO);
            resultVo.setCommunity(BigDecimal.ZERO);
            resultVo.setFactory(BigDecimal.ZERO);
            resultVo.setJdMarket(BigDecimal.ZERO);
            resultVo.setStandardRetailPrice(standardRetailPrice.get(k) == null ? null : standardRetailPrice.get(k).getPrice());
            if (BigDecimal.ZERO.compareTo(tmallChaoshiV) != 0 && BigDecimal.ZERO.compareTo(tmallChaoshiA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，天猫超市，总销量为0");
                resultVo.setTmallChaoshi(tmallChaoshiA.divide(tmallChaoshiV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(jdDeluxuV) != 0 && BigDecimal.ZERO.compareTo(jdDeluxuA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，京东特仑苏，总销量为0");
                resultVo.setJdDeluxu(jdDeluxuA.divide(jdDeluxuV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(distributionV) != 0 && BigDecimal.ZERO.compareTo(distributionA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，线上分销，总销量为0");
                resultVo.setDistribution(distributionA.divide(distributionV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(jdPopV) != 0 && BigDecimal.ZERO.compareTo(jdPopA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，京东pop店，总销量为0");
                resultVo.setJdPop(jdPopA.divide(jdPopV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(expandBusinessDepartmentV) != 0 && BigDecimal.ZERO.compareTo(expandBusinessDepartmentA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，拓展业务部，总销量为0");
                resultVo.setExpandBusinessDepartment(expandBusinessDepartmentA.divide(expandBusinessDepartmentV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(tmallV) != 0 && BigDecimal.ZERO.compareTo(tmallA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，天猫旗舰店，总销量为0");
                resultVo.setTmall(tmallA.divide(tmallV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(pddV) != 0 && BigDecimal.ZERO.compareTo(pddA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，拼多多，总销量为0");
                resultVo.setPdd(pddA.divide(pddV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(contentMarketingV) != 0 && BigDecimal.ZERO.compareTo(contentMarketingA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，内容营销，总销量为0");
                resultVo.setContentMarketing(contentMarketingA.divide(contentMarketingV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(communityV) != 0 && BigDecimal.ZERO.compareTo(communityA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，社区团购，总销量为0");
                resultVo.setCommunity(communityA.divide(communityV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(factoryV) != 0 && BigDecimal.ZERO.compareTo(factoryA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，工厂直营，总销量为0");
                resultVo.setFactory(factoryA.divide(factoryV, 2, BigDecimal.ROUND_HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(jdMarketV) != 0 && BigDecimal.ZERO.compareTo(jdMarketA) != 0) {
                //throw new IllegalArgumentException("产品【"+ k +"】，京东商城，总销量为0");
                resultVo.setJdMarket(jdMarketA.divide(jdMarketV, 2, BigDecimal.ROUND_HALF_UP));
            }

            resultList.add(resultVo);
        }
        Page<PlatformPriceVo> result = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        //分页
        List<PlatformPriceVo> subList = resultList.stream().skip((pageable.getPageNumber() - 1) * pageable.getPageSize()).limit(pageable.getPageSize()).
                collect(Collectors.toList());
        result.setRecords(subList);
        result.setTotal(resultList.size());
        result.setCurrent(pageable.getPageNumber());
        result.setPages(resultList.size() % pageable.getPageSize() == 0 ? resultList.size() / pageable.getPageSize() : resultList.size() / pageable.getPageSize() + 1);

        return result;
    }

    @Override
    public List<Ce1MnjtFullVo2> findDataByIds(List<String> ids) {

        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }

        List<Ce1Mnjt> ce1Mnjts = this.listByIds(ids);
        List<Ce1MnjtInfo> ce1MnjtInfos = this.ce1MnjtInfoMapper.selectList(Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, ids));
        Map<String, Ce1MnjtInfo> ce1MnjtInfoMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(ce1MnjtInfos)) {
            ce1MnjtInfoMap = ce1MnjtInfos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
        }
        if (CollectionUtils.isNotEmpty(ce1Mnjts)) {
            Collection<Ce1MnjtFullVo2> ce1MnjtFullVo2s = nebulaToolkitService.copyCollectionByWhiteList(ce1Mnjts, Ce1Mnjt.class, Ce1MnjtFullVo2.class, LinkedHashSet.class, ArrayList.class);
            for (Ce1MnjtFullVo2 ce1MnjtFullVo2 : ce1MnjtFullVo2s) {
                Ce1MnjtInfo ce1MnjtInfo = ce1MnjtInfoMap.get(ce1MnjtFullVo2.getCId());
                if (ce1MnjtInfo != null) {
                    ce1MnjtFullVo2.setSalesVolumes(ce1MnjtInfo.getSalesVolumes());
                    ce1MnjtFullVo2.setSalesIncludingTaxNet(ce1MnjtInfo.getSalesIncludingTaxNet());
                }
                ce1MnjtFullVo2.setTpmCustomerCode(ce1MnjtFullVo2.getCustomerCode() + ce1MnjtFullVo2.getSaleOrgCode() + ce1MnjtFullVo2.getDistributionChannelCode() + ce1MnjtFullVo2.getProductTeamCode());
            }
            return (List<Ce1MnjtFullVo2>) ce1MnjtFullVo2s;
        }
        return Lists.newArrayList();
    }

    @Override
    public Page<Ce1MnjtFullVo2> findDataPage(Pageable pageable, String ds) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1,50));
        Page<Ce1MnjtFullVo2> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        return this.baseMapper.findDataByPage(page, ds);
    }

    @Override
    public List<Ce1MnjtFullVo2> findCe1DataByCode(Page<Ce1MnjtFullVo2> page, List<String> codes, Integer codeType) {

        Page<Ce1MnjtFullVo2> ce1DataPage = this.ce1MnjtMapper.findCe1DataPage(page, codes, codeType);
        return ce1DataPage.getRecords();
    }

    @Override
    public Integer getTotalNumber(List<String> codes, Integer codeType) {
        Integer totalNumber = 0;
        switch (codeType) {
            case 1:
                totalNumber = this.ce1MnjtMapper.selectCount(Wrappers.lambdaQuery(Ce1Mnjt.class).in(Ce1Mnjt::getMonthVerifyCode, codes));
                break;
            case 2:
                totalNumber = this.ce1MnjtMapper.selectCount(Wrappers.lambdaQuery(Ce1Mnjt.class).in(Ce1Mnjt::getDaySaleVerifyCode, codes));
                break;
            default:
        }
        return totalNumber;
    }

    /**
     * 考勤通报管理查询分摊数据
     *
     * @param dto
     * @return
     */
    @Override
    public List<Ce1ExamineCircularSearchVo> findExamineCircularDataList(Ce1ExamineCircularSearchDto dto, String cacheKey) {
        if (StringUtils.isNotEmpty(dto.getStartDate()) && StringUtils.isNotEmpty(dto.getEndDate())) {
            Validate.isTrue(StringUtils.equals(dto.getStartDate().substring(0, 7), dto.getEndDate().substring(0, 7)), "查询时间不能跨月！");
        }

        cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey;
        if (StringUtils.isNotEmpty(cacheKey)) {
            redisService.del(cacheKey);
        }
        if (StringUtils.isEmpty(dto.getSaleOrgCode())
                || StringUtils.isEmpty(dto.getCustomerCode())
                || StringUtils.isEmpty(dto.getStartDate())
                || StringUtils.isEmpty(dto.getEndDate())) {
            return Lists.newArrayList();
        }
        //用的MDG客户编码查询
        List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(com.google.common.collect.Lists.newArrayList(dto.getCustomerCode()));
        Validate.notEmpty(customerVos, "客户编码[%s]客户信息不存在！", dto.getCustomerCode());

        //销售公司
        List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllParentBySalesOrgCode(dto.getSaleOrgCode());
        salesOrgVos = salesOrgVos.stream().filter(e -> StringUtils.equals(SalesOrgLevelTypeEnum.MECHANISM.getCode(), e.getSalesOrgLevel())).collect(Collectors.toList());
        Validate.notEmpty(salesOrgVos, "销售组织编码[%s]，未查询到销售公司！", dto.getSaleOrgCode());
        String companyCode = salesOrgVos.get(0).getErpCode();

        dto.setSaleOrgCode(companyCode);
        dto.setCustomerCode(customerVos.get(0).getErpCode());
        dto.setStartDate(dto.getStartDate().replaceAll("-", ""));
        dto.setEndDate(dto.getEndDate().replaceAll("-", ""));
        List<Ce1MnjtFullVo2> dataList = this.ce1MnjtMapper.findExamineCircularDataList(dto);

        //数据处理
        List<Ce1ExamineCircularSearchVo> list = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(dataList)) {
            List<String> productCodeList = dataList.stream().map(Ce1MnjtFullVo2::getProductCode).distinct().collect(Collectors.toList());
            List<ProductVo> productVoList = productVoService.findMainDetailsByProductCodes(productCodeList);
            Map<String, ProductVo> productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2));

            List<String> idList = dataList.stream().flatMap(o -> Arrays.stream(o.getCids().split(","))).collect(Collectors.toList());
            List<Ce1MnjtInfo> ce1Infos = this.ce1MnjtInfoMapper.selectList(Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, idList));
            Map<String, Ce1MnjtInfo> ce1InfoMap = ce1Infos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
            //含税销售额(净额)
            BigDecimal salesIncludingTaxNet = BigDecimal.ZERO;
            for (Ce1MnjtFullVo2 v : dataList) {
                String[] idArr = v.getCids().split(",");
                for (String id : idArr) {
                    Ce1MnjtInfo ce1MnjtInfo = ce1InfoMap.get(id);
                    if (ce1MnjtInfo != null && Objects.nonNull(ce1MnjtInfo.getSalesIncludingTaxNet())) {
                        salesIncludingTaxNet = salesIncludingTaxNet.add(new BigDecimal(ce1MnjtInfo.getSalesIncludingTaxNet()));
                    }
                }
                Ce1ExamineCircularSearchVo searchVo = new Ce1ExamineCircularSearchVo();
                searchVo.setProductCode(v.getProductCode());
                if (productMap.containsKey(v.getProductCode())) {
                    ProductVo productVo = productMap.get(v.getProductCode());
                    searchVo.setProductName(productVo.getProductName());
                    searchVo.setProductBrandCode(productVo.getProductBrandCode());
                    searchVo.setProductBrandName(productVo.getProductBrandName());
                    searchVo.setProductLevelCode(productVo.getProductCategoryCode());
                    searchVo.setProductLevelName(productVo.getProductCategoryName());
                    searchVo.setSubProductLevelCode(productVo.getProductLevelCode());
                    searchVo.setSubProductLevelName(productVo.getProductLevelName());
                }
                searchVo.setSplitAmount(salesIncludingTaxNet);
                searchVo.setProductCode(searchVo.getProductCode());
                list.add(searchVo);
            }
        }
        list = list.stream().filter(e -> Objects.nonNull(e.getSplitAmount()) && BigDecimal.ZERO.compareTo(e.getSplitAmount()) < 0).collect(Collectors.toList());
        //均摊计算用
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list) && StringUtils.isNotEmpty(cacheKey)) {
            Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(Ce1ExamineCircularSearchVo::getProductCode, Ce1ExamineCircularSearchVo::getSplitAmount, (v1, v2) -> v2));
            redisService.set(cacheKey, JSONObject.toJSONString(map), 60 * 60 * 12);
        }
        return list;
    }

    @Override
    public List<Ce1MnjtFullVo2> findDataByCustomerCodeAndDate(String customerCode, String productCode, List<String> dateList) {
        return this.ce1MnjtInfoMapper.findDataByCustomerAndDatas(customerCode, productCode, dateList);
    }

    @Override
    public List<Ce1MnjtFullVo2> findListByCondition(Ce1MnjtFullDto dto) {

        return this.ce1MnjtInfoMapper.findListByCondition(dto);
    }

    @Override
    public long findPageTotalByCondition(Ce1MnjtFullDto ce1MnjtFullDto) {
        if (Objects.isNull(ce1MnjtFullDto)) {
            return 0L;
        }
        return this.baseMapper.findPageTotalByCondition(ce1MnjtFullDto);
    }

    @Override
    public Page<Ce1MnjtFullVo2> findPageByCondition(Page<Ce1MnjtFullVo2> page, Ce1MnjtFullDto ce1MnjtFullDto) {
        if (Objects.isNull(ce1MnjtFullDto)) {
            return new Page<>();
        }
        return this.baseMapper.findPageByCondition(page, ce1MnjtFullDto);
    }

    @Override
    public List<Ce1MnjtFullVoExportsVo> findExportsByParams(Ce1MnjtFullDto ce1MnjtFull) {

        List<Ce1MnjtFullVoExportsVo> list = this.baseMapper.findExportsByParams(ce1MnjtFull);

        if (CollUtil.isEmpty(list)) {

            return Lists.newArrayList();

        }
        list.forEach(item -> {

            String invoicingTypeCode = item.getInvoicingTypeCode();

            if (CharSequenceUtil.isNotBlank(invoicingTypeCode)) {

                String invoicingTypeName = InvoiceTypeEnum.getNameByValue(invoicingTypeCode);

                item.setInvoicingTypeName(invoicingTypeName);
            }
        });

        return list;
    }

    @Override
    public BigDecimal getSalesIncludingTaxNetTotal(Ce1MnjtFullDto ce1MnjtFull) {

        return this.baseMapper.getSalesIncludingTaxNetTotal(ce1MnjtFull);
    }

    @Override
    public List<String> findCe1ByDs(String ds) {

        if (CharSequenceUtil.isEmpty(ds)) {
            return null;
        }

        return this.ce1MnjtMapper.findCe1IdByDs(ds);

    }

    @Override
    public void deleteCe1(String ds) {

        List<String> ce1ByDs = this.findCe1ByDs(ds);

        if (CollUtil.isEmpty(ce1ByDs)) {
            return;
        }

        this.baseMapper.delete(Wrappers.lambdaQuery(Ce1Mnjt.class).eq(Ce1Mnjt::getDs, ds));

        this.ce1MnjtInfoMapper.delete(Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, ce1ByDs));

        this.ce1MnjtCostDisMapper.delete(Wrappers.lambdaQuery(Ce1MnjtCostDis.class).in(Ce1MnjtCostDis::getTpmCe1Id, ce1ByDs));
    }

    @Override
    public Integer getCe1MnjtTotal(String ds) {
        Integer total = this.ce1MnjtMapper.selectCount(Wrappers.lambdaQuery(Ce1Mnjt.class).eq(Ce1Mnjt::getDs, ds));
        return ObjectUtil.isNull(total) ? 0 : total;

    }

    private void buildResult(List<Ce1MnjtFullVo2> records, Map<String, Ce1MnjtInfo> ce1MnjtInfoMap, Map<String, Ce1MnjtCostDis> ce1MnjtCostDisMap) {
        for (Ce1MnjtFullVo2 record : records) {
            String[] ids = record.getCids().split(",");
            record.setSalesVolumes(BigDecimal.ZERO);
            record.setSalesIncludingTaxNet("0");
            record.setSalesTaxAmount("0");
            record.setStandardNumTon(BigDecimal.ZERO);
            record.setNetWeight(BigDecimal.ZERO);
            record.setGrossWeight(BigDecimal.ZERO);
            for (String id : ids) {
                Ce1MnjtInfo ce1MnjtInfo = ce1MnjtInfoMap.get(id);
                if (ce1MnjtInfo != null) {
                    record.setCostCenter(ce1MnjtInfo.getCostCenter());
                    record.setSenderCode(ce1MnjtInfo.getSenderCode());
                    record.setSalesVolumes(record.getSalesVolumes().add(Optional.ofNullable(ce1MnjtInfo.getSalesVolumes()).orElse(BigDecimal.ZERO)));
                    record.setSalesIncludingTaxNet(new BigDecimal(record.getSalesIncludingTaxNet()).add(Optional.of(new BigDecimal(ce1MnjtInfo.getSalesIncludingTaxNet())).orElse(BigDecimal.ZERO)).toPlainString());
                    record.setSalesTaxAmount(new BigDecimal(record.getSalesTaxAmount()).add(Optional.of(new BigDecimal(ce1MnjtInfo.getSalesTaxAmount())).orElse(BigDecimal.ZERO)).toPlainString());
                    record.setStandardNumTon(record.getStandardNumTon().add(Optional.ofNullable(ce1MnjtInfo.getStandardNumTon()).orElse(BigDecimal.ZERO)));
                    record.setNetWeight(record.getNetWeight().add(Optional.ofNullable(ce1MnjtInfo.getNetWeight()).orElse(BigDecimal.ZERO)));
                    record.setGrossWeight(record.getGrossWeight().add(Optional.ofNullable(ce1MnjtInfo.getGrossWeight()).orElse(BigDecimal.ZERO)));
                }
            }

            if (StringUtils.isNotEmpty(record.getInvoicingTypeCode())) {
                record.setInvoicingTypeName(InvoiceTypeEnum.getNameByValue(record.getInvoicingTypeCode()));
            }


        }
    }

    /**
     * 查询客户在活动时间内销售的产品个数(取过账日期)
     *
     * @param dto
     * @return
     */
    @Override
    public List<Ce1MnjtFullVo2> findProductListByCustomerGroup(Ce1MnjtSearchDto dto) {
        List<Ce1MnjtFullVo2> ce1MnjtVos = ce1MnjtMapper.findProductListByCustomerGroup(dto);
        return ce1MnjtVos;
    }

    /**
     * 参数赋值
     *
     * @param ce1MnjtFullVo
     * @param itemValue
     */
    private void paramsAssignment(List<Ce1MnjtFullVo> itemValue, Ce1MnjtFullVo ce1MnjtFullVo) {
        //销售数量
        BigDecimal salesVolumes = itemValue
                .stream()
                .filter(item ->
                        (ObjectUtil.isNotNull(item.getSalesVolumes())
                                && item.getSalesVolumes().compareTo(BigDecimal.ZERO) > 0))
                .map(Ce1MnjtFullVo::getSalesVolumes).reduce(BigDecimal.ZERO, BigDecimal::add);
        //含税销售额(净额)
        BigDecimal salesIncludingTaxNetDecimal = itemValue
                .stream()
                .filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getSalesIncludingTaxNet()))
                .map(Ce1MnjtFullVo::getSalesIncludingTaxNet)
                .filter(Objects::nonNull)
                .map(BigDecimal::new)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        String salesIncludingTaxNet = String.valueOf(salesIncludingTaxNetDecimal);
        //销售含税金额
        BigDecimal salesTaxAmountDecimal = itemValue
                .stream()
                .filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getSalesTaxAmount()))
                .map(Ce1MnjtFullVo::getSalesTaxAmount)
                .map(BigDecimal::new)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        String salesTaxAmount = String.valueOf(salesTaxAmountDecimal);
        //标准数量(顿)standardNumTon
        BigDecimal standardNumTon = itemValue
                .stream()
                .filter(item ->
                        (ObjectUtil.isNotNull(item.getStandardNumTon())
                                && item.getStandardNumTon().compareTo(BigDecimal.ZERO) > 0))
                .map(Ce1MnjtFullVo::getStandardNumTon)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //净重量(KG) netWeight
        BigDecimal netWeight = itemValue
                .stream()
                .filter(item ->
                        ObjectUtil.isNotNull(item.getNetWeight())
                                && item.getNetWeight().compareTo(BigDecimal.ZERO) > 0)
                .map(Ce1MnjtFullVo::getNetWeight)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //毛重 grossWeight
        BigDecimal grossWeight = itemValue
                .stream()
                .filter(item ->
                        ObjectUtil.isNotNull(item.getGrossWeight())
                                && item.getGrossWeight().compareTo(BigDecimal.ZERO) > 0)
                .map(Ce1MnjtFullVo::getGrossWeight)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        ce1MnjtFullVo.setSalesVolumes(salesVolumes);
        ce1MnjtFullVo.setSalesIncludingTaxNet(salesIncludingTaxNet);
        ce1MnjtFullVo.setSalesTaxAmount(salesTaxAmount);
        ce1MnjtFullVo.setStandardNumTon(standardNumTon);
        ce1MnjtFullVo.setNetWeight(netWeight);
        ce1MnjtFullVo.setGrossWeight(grossWeight);
    }
}




