package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.biz.crm.kms.business.account.receivable.sdk.dto.KmsFindZmsd121Dto;
import com.biz.crm.kms.business.account.receivable.sdk.listener.KmsFind121Listener;
import com.biz.crm.kms.business.account.receivable.sdk.vo.KmsFindZmsd121Response;
import com.biz.crm.kms.business.account.receivable.sdk.vo.KmsFindZmsd121Vo;
import com.biz.crm.tpm.business.third.system.local.service.KmsZmsd121Service;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 为kms对账单提供数据
 */
@Slf4j
@Component
public class KmsFindZmsd121ListenerImpl implements KmsFind121Listener {

    @Autowired(required = false)
    private KmsZmsd121Service kmsZmsd121Service;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public KmsFindZmsd121Response findByConditions(KmsFindZmsd121Dto dto) {
        if (ObjectUtils.isEmpty(dto)){
            return null;
        }
        KmsFindZmsd121Response kmsFindZmsd121Response = new KmsFindZmsd121Response();
        List<KmsFindZmsd121Vo> kmsFindZmsd121VoList = this.kmsZmsd121Service.findByKmsConditions(dto);
        if (CollectionUtils.isNotEmpty(kmsFindZmsd121VoList)) {
            kmsFindZmsd121Response.setKmsFindZmsd121VoList(kmsFindZmsd121VoList);
        }
        return kmsFindZmsd121Response;
    }
}
