package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.red.packet.sdk.dto.MemberRedPacketDto;
import com.biz.crm.mn.third.system.red.packet.sdk.dto.RedPacketQuerySchemeDto;
import com.biz.crm.mn.third.system.red.packet.sdk.service.RedPacketService;
import com.biz.crm.mn.third.system.red.packet.sdk.vo.RedPacketQuerySchemeVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.third.system.sdk.constants.RedPacketConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/30 15:21
 * @description：会议红包服务
 */
@Service
@Slf4j
public class RedPacketServiceImpl implements RedPacketService {

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    /**
     * 红包方案查询接口
     *
     * @param dto
     * @return
     */
    @Override
    public List<RedPacketQuerySchemeVo> redPacketQueryScheme(RedPacketQuerySchemeDto dto) {

        Validate.notNull(dto, "输入参数不能为空");
        RedPacketQueryScheme2Dto dto2 = this.nebulaToolkitService.copyObjectByWhiteList(dto, RedPacketQueryScheme2Dto.class, null, null);
        List<RedPacketQueryScheme2Vo> redPacketQuerySchemeVoList = activityDetailPlanSdkService.redPacketQueryScheme(dto2);
        if (CollectionUtils.isNotEmpty(redPacketQuerySchemeVoList)) {
            Collection<RedPacketQuerySchemeVo> redPacketQuerySchemeVos = this.nebulaToolkitService.copyCollectionByBlankList(redPacketQuerySchemeVoList, RedPacketQueryScheme2Vo.class, RedPacketQuerySchemeVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<RedPacketQuerySchemeVo>) redPacketQuerySchemeVos;
        }
        return new ArrayList<>();
    }

    @Override
    public void memberRedPacket(List<MemberRedPacketDto> dtos) {

        if (CollectionUtils.isNotEmpty(dtos)) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            //数据
            mqMessageVo.setMsgBody(JSON.toJSONString(dtos));
            mqMessageVo.setTopic(RedPacketConstant.TPM_MEMBER_RED_PACKET_TOPIC + RocketMqUtil.mqEnvironment());
            //标签
            mqMessageVo.setTag(RedPacketConstant.TPM_MEMBER_RED_PACKET_TAG);
            log.info("会员红包接收数据发送mq：{}", JSON.toJSONString(dtos));
            rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }
}
