package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.biz.crm.mn.third.system.sap.fi.sdk.dto.AccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.ChargeAgainstAccountingVoucherDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SapRedInvoiceSaleOrderCreateDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.SapFiService;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.ChargeAgainstAccountingVoucherVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.SapAccountingVoucherVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountSonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQueryDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQuerySonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQuerySonCompanyVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQueryVo;
import com.biz.crm.tpm.business.third.system.sdk.service.SAPCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/14 14:45
 * @description：SAP接口服务
 */
@Service
public class SAPCenterServiceImpl implements SAPCenterService {

    @Autowired(required = false)
    private SapFiService sapFiService;

    @Autowired(required = false)
    private SapSdApiService sapSdApiService;


    @Override
    public SapAccountingVoucherVo pushSapAccountingVoucher(AccountingVoucherDto dto) {
        return sapFiService.pushSapAccountingVoucher(dto);
    }

    @Override
    public ChargeAgainstAccountingVoucherVo pushSapChargeAgainstAccountingVoucher(ChargeAgainstAccountingVoucherDto dto) {
        return sapFiService.pushSapChargeAgainstAccountingVoucher(dto);
    }

    @Override
    public void auditFeeUpAccount(AuditFeeUpAccountDto dto) {
        sapSdApiService.auditFeeUpAccount(dto);
    }

    @Override
    public void auditFeeUpAccountSonCompany(AuditFeeUpAccountSonCompanyDto dto) {
        sapSdApiService.auditFeeUpAccountSonCompany(dto);
    }

    @Override
    public FeePoolQueryVo feePoolQuery(FeePoolQueryDto dto) {
        return sapSdApiService.feePoolQuery(dto);
    }

    @Override
    public FeePoolQuerySonCompanyVo feePoolQuerySonCompany(FeePoolQuerySonCompanyDto dto) {
        return sapSdApiService.feePoolQuerySonCompany(dto);
    }

    @Override
    public void pushSapSaleOrderCreate(SapRedInvoiceSaleOrderCreateDto dto) {
        sapSdApiService.pushSapSaleOrderCreate(dto);
    }
}
