package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SapRedInvoiceSaleOrderCreateCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.UpAccountCallBackService;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.sdk.service.AuditSdkService;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.EventPrepaymentService;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * @author ：dengwei
 * @date ：Created in 2023/1/6 15:57
 * @description：核销上账回调
 */
@Service
@Slf4j
public class UpAccountCallBackServiceImpl implements UpAccountCallBackService {


    @Autowired(required = false)
    private AuditSdkService auditSdkService;
    @Autowired(required = false)
    private EventPrepaymentService eventPrepaymentService;

    @Autowired(required = false)
    private TpmExamineCircularService tpmExamineCircularService;

    @Autowired(required = false)
    private AuditHandleSdkService auditHandleSdkService;


    @Override
    public void sdAuditCostPostingHeadCallback(AuditCostPostingCallbackDto dto) {
        try {
            auditSdkService.sdAuditCostPostingHeadCallback(dto);
        }catch (Exception e){
            e.printStackTrace();
            log.error("核销费用上账回调--总部异常1",e);
        }

        /**
         * 预付活动管理 总公司回调
         */
        try {
            eventPrepaymentService.eventPrePaymentHeadCallback(dto);
        }catch (Exception e){
            log.error("核销费用上账回调--总部异常2",e);
        }

        /**
         * 考核通报总公司回调
         */
        try {
            tpmExamineCircularService.examineCircularHeadCallback(dto);
        }catch (Exception e){
            log.error("核销费用上账回调--总部异常3",e);
        }

        /**
         * 直接上账总公司回调
         * 
         */
        try {
            this.auditHandleSdkService.headquartersDiscountCallBack(dto);
        }catch (Exception e){
            log.error("核销费用上账回调--总部【直接上账】异常",e);
        }

    }

    @Override
    public void sdAuditCostPostingBranchCallback(SonAuditCostPostingCallbackDto dto) {
        try {
            auditSdkService.sdAuditCostPostingBranchCallback(dto);
        }catch (Exception e){
            e.printStackTrace();
            log.error("核销费用上账接口回调--分公司异常1",e);
        }

        /**
         * 预付活动管理 分子公司回调
         */
        try {
            eventPrepaymentService.eventPrePaymentSonCallback(dto);
        }catch (Exception e){
            log.error("核销费用上账接口回调--分公司异常2",e);
        }

        /**
         * 考核通报分子公司回调
         */
        try {
            tpmExamineCircularService.examineCircularSonCallback(dto);
        }catch (Exception e){
            log.error("核销费用上账接口回调--分公司异常3",e);
        }

        /**
         * 直接上账分子公司回到
         */
        try {
            this.auditHandleSdkService.sonCompanyDiscountCallBack(dto);
        }catch (Exception e){
            log.error("核销费用上账接口回调--分公司【直接上账】异常",e);
        }

    }

    @Override
    public void saleOrderCreateCallback(SapRedInvoiceSaleOrderCreateCallbackDto dto) {
        auditSdkService.saleOrderCreateCallback(dto);
    }

}
