package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Zmsd121Vo;
import com.biz.crm.tpm.business.third.system.local.entity.Zmsd121;
import com.biz.crm.tpm.business.third.system.local.mapper.Zmsd121Mapper;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd121Service;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmZmsd121Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @ClassName Zmsd121ServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/13
 */
@Service
@Slf4j
public class Zmsd121ServiceImpl implements Zmsd121Service {

    @Autowired(required = false)
    private Zmsd121Mapper zmsd121Mapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    public void saveEntityBatch(String ds, List<Zmsd121Vo> zmsd121VoList) {

        List<Zmsd121> entityList = new ArrayList<>();
        parseDataphinVo2TpmEntiy(zmsd121VoList, entityList);
        Date date = new Date();
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();

        //设置公参
        for(Zmsd121 entity : entityList){
            //填充继承基础字段
            entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            entity.setCreateAccount(loginUser.getAccount());
            entity.setCreateName(loginUser.getRealName());
            entity.setModifyAccount(loginUser.getAccount());
            entity.setModifyName(loginUser.getRealName());
            entity.setCreateTime(date);
            entity.setModifyTime(date);
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDs(ds);
        }
        zmsd121Mapper.saveBatch(entityList);
    }

    private void parseDataphinVo2TpmEntiy(List<Zmsd121Vo> zmsd121VoList, List<Zmsd121> entityList) {
        for(Zmsd121Vo dataphinVo : zmsd121VoList){
            Zmsd121 entity = new Zmsd121();
            entity.setClient(dataphinVo.getClient());
            entity.setCompanyCode(dataphinVo.getCompany_code());
            entity.setSaleOrgCode(dataphinVo.getSale_org_code());
            entity.setProductTeamCode(dataphinVo.getProduct_team_code());
            entity.setCustomerCode(dataphinVo.getCustomer_code());
            entity.setFiscalYear(dataphinVo.getFiscal_year());
            entity.setAccountingPeriod(dataphinVo.getAccounting_period());
            entity.setMaterialCode(dataphinVo.getMaterial_code());
            entity.setOpenBalance(dataphinVo.getOpen_balance());
            entity.setMakeAmount(dataphinVo.getMake_amount());
            entity.setFrozenAmount(dataphinVo.getFrozen_amount());
            entity.setAdjustTransferIn(dataphinVo.getAdjust_transfer_in());
            entity.setDeductionAmount(dataphinVo.getDeduction_amount());
            entity.setAdjustTransferOut(dataphinVo.getAdjust_transfer_out());
            entity.setEndingBalance(dataphinVo.getEnding_balance());
            entity.setKneadPrice(dataphinVo.getKnead_price());
            entity.setTpmWeight(dataphinVo.getTpm_weight());
            entity.setCurrency(dataphinVo.getCurrency());
            entity.setCreatorCode(dataphinVo.getCreator_code());
            entity.setDpCreateDate(dataphinVo.getCreate_date());
            entity.setDpCreateTime(dataphinVo.getCreate_time());
            entity.setChangerCode(dataphinVo.getChanger_code());
            entity.setChangeDate(dataphinVo.getChange_date());
            entity.setChangeTime(dataphinVo.getChange_time());
            entity.setDs(dataphinVo.getDs());
            entityList.add(entity);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByDs(String ds) {
        zmsd121Mapper.deleteByDs(ds);
    }

    @Override
    public Page<TpmZmsd121Vo> findByDs(Page<TpmZmsd121Vo> page121, String ds, String accountingPeriod, CustomerVo customerVo, SalesOrgVo salesOrgVo, String businessFormatCode) {
        return zmsd121Mapper.findByDs(page121, ds, accountingPeriod, customerVo, salesOrgVo, businessFormatCode);
    }

    @Override
    public Integer findTotal(String ds, String accountingPeriod, CustomerVo customerReqVo, SalesOrgVo salesOrgReqVo, String businessFormatCode) {
        return zmsd121Mapper.findTotal(ds, accountingPeriod, customerReqVo, salesOrgReqVo, businessFormatCode);
    }

    @Override
    public List<String> findCustomerListByDate(String startDate, String endDate,String customerCode, String ds) {
        return zmsd121Mapper.findCustomerListByDate(startDate,endDate,customerCode, ds);
    }
    @Override
    public List<TpmZmsd121Vo> findListByDate(String startDate, String endDate,String customerCode, String ds) {
        return zmsd121Mapper.findListByDate(startDate,endDate,customerCode, ds);
    }
}
