package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Zmsd187Vo;
import com.biz.crm.tpm.business.third.system.local.entity.Zmsd187;
import com.biz.crm.tpm.business.third.system.local.mapper.Zmsd187Mapper;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd187Service;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmZmsd187Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @ClassName Zmsd187ServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/13
 */
@Service
@Slf4j
public class Zmsd187ServiceImpl implements Zmsd187Service {

    @Autowired(required = false)
    private Zmsd187Mapper zmsd187Mapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveEntityBatch(String ds, List<Zmsd187Vo> zmsd187VoList) {

        List<Zmsd187> entityList = new ArrayList<>();
        parseDataphinVo2TpmEntiy(zmsd187VoList, entityList);
        Date date = new Date();
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();

        //设置公参
        for(Zmsd187 entity : entityList){
            //填充继承基础字段
            entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            entity.setCreateAccount(loginUser.getAccount());
            entity.setCreateName(loginUser.getRealName());
            entity.setModifyAccount(loginUser.getAccount());
            entity.setModifyName(loginUser.getRealName());
            entity.setCreateTime(date);
            entity.setModifyTime(date);
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        zmsd187Mapper.saveBatch(entityList);
    }

    private void parseDataphinVo2TpmEntiy(List<Zmsd187Vo> zmsd187VoList, List<Zmsd187> entityList) {
        for(Zmsd187Vo dataphinVo : zmsd187VoList){
            Zmsd187 entity = new Zmsd187();
            entity.setClient(dataphinVo.getClient());
            entity.setCompanyCode(dataphinVo.getCompany_code());
            entity.setSaleOrgCode(dataphinVo.getSale_org_code());
            entity.setDistributionChannelCode(dataphinVo.getDistribution_channel_code());
            entity.setProductTeamCode(dataphinVo.getProduct_team_code());
            entity.setCustomerCode(dataphinVo.getCustomer_code());
            entity.setSaleGroupCode(dataphinVo.getSale_group_code());
            entity.setSaleDepartmentCode(dataphinVo.getSale_department_code());
            entity.setCustomerName(dataphinVo.getCustomer_name());
            entity.setFiscalYear(dataphinVo.getFiscal_year());
            entity.setAccountingPeriod(dataphinVo.getAccounting_period());
            entity.setOpeningBalance(dataphinVo.getOpening_balance());
            entity.setTpmShift(dataphinVo.getTpm_shift());
            entity.setMakeAmount(dataphinVo.getMake_amount());
            entity.setTransferInAmount(dataphinVo.getTransfer_in_amount());
            entity.setTransferOutAmount(dataphinVo.getTransfer_out_amount());
            entity.setDeductionAmount(dataphinVo.getDeduction_amount());
            entity.setEndingBalance(dataphinVo.getEnding_balance());
            entity.setNotDeductedAmount(dataphinVo.getNot_deducted_amount());
            entity.setActualExpenseBalance(dataphinVo.getActual_expense_balance());
            entity.setRecordDate(dataphinVo.getRecord_date());
            entity.setTimestampOdps(dataphinVo.getTimestamp_odps());
            entity.setDs(dataphinVo.getDs());
            entityList.add(entity);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByDs(String ds) {
        zmsd187Mapper.deleteByDs(ds);
    }

    @Override
    public Page<TpmZmsd187Vo> findByDs(Page<TpmZmsd187Vo> page187, String ds, String accountingPeriod, CustomerVo customerVo, SalesOrgVo salesOrgVo, String businessFormatCode, List<String> customerCodeList) {
        return zmsd187Mapper.findByDs(page187, ds, accountingPeriod, customerVo, salesOrgVo, businessFormatCode,customerCodeList);
    }

    @Override
    public Integer findTotal(String ds, String accountingPeriod, CustomerVo customerVo, SalesOrgVo salesOrgVo, String businessFormatCode, List<String> customerCodeList) {
        return zmsd187Mapper.findTotal(ds, accountingPeriod, customerVo, salesOrgVo, businessFormatCode, customerCodeList);
    }
}
