/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmZtfi099ForEctQueryDto;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Sap099\u83b7\u5229\u80fd\u529b\u5206\u6790\u6570\u636e\u8868"})
@RestController
@RequestMapping(value={"/v1/tpmProfitabilityAnalysis"})
public class TpmProfitabilityAnalysisController {
    private static final Logger log = LoggerFactory.getLogger(TpmProfitabilityAnalysisController.class);
    @Autowired(required=false)
    private TpmProfitabilityAnalysisService tpmProfitabilityAnalysisService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u624b\u52a8\u540c\u6b65\u83b7\u5229\u80fd\u529b\u5206\u6790\u6570\u636e099(\u65e5\u671f\u683c\u5f0f202211)")
    @GetMapping(value={"handExecZtfi099"})
    public Result<?> handExecZtfi099(@RequestParam(value="yearMonth", required=false) String yearMonth, @RequestParam(value="companyCode", required=false) String companyCode, @RequestParam(value="accountDate", required=false) String accountDate) {
        try {
            Assert.hasText((String)yearMonth, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
            if (yearMonth.contains("-")) {
                yearMonth = yearMonth.replace("-", "");
            }
            if (StringUtils.isNotEmpty((CharSequence)accountDate) && accountDate.contains("-")) {
                accountDate = accountDate.replace("-", "");
            }
            Assert.isTrue((yearMonth.length() == 6 ? 1 : 0) != 0, (String)"\u5e74\u6708\u683c\u5f0f\u4e0d\u5408\u6cd5![yyyyMM]");
            String lockKey = "pull_bjx099_data:lock:" + yearMonth;
            boolean isLock = this.redisLockService.isLock(lockKey);
            Assert.isTrue((!isLock ? 1 : 0) != 0, (String)("\u4e0a\u6b21\u62c9\u53d6\u3010" + yearMonth + "\u3011\u6708\u5c1a\u672a\u5b8c\u6210"));
            this.tpmProfitabilityAnalysisService.handPull099ByYearMonthAsync(yearMonth, companyCode, accountDate);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6tpm\u4e2d\u5df2\u5b58\u5165\u7684099\u6570\u636e")
    @GetMapping(value={"/findData4Ect"})
    public Result<Page<TpmProfitabilityAnalysisVo>> findData4Ect(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="ectZtfi099QueryDto", value="ectZtfi099QueryDto") TpmZtfi099ForEctQueryDto ectZtfi099QueryDto) {
        try {
            Page data4Ect = this.tpmProfitabilityAnalysisService.findData4Ect(pageable, ectZtfi099QueryDto);
            return Result.ok((Object)data4Ect);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

