/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.local.service.PullFeePoolDataService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PullFeePoolDataAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(PullFeePoolDataAutoSyncXxlJob.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private PullFeePoolDataService pullFeePoolDataService;

    @DynamicTaskService(cornExpression="0 0 6 2 * ?", taskDesc="\u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e187\u548c121")
    public void pullFeePoolData() {
        this.loginUserService.refreshAuthentication(null);
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        int month = calendar.get(2);
        if (month == 0) {
            month = 12;
        }
        String ds = DateUtil.format((Date)calendar.getTime(), (String)"yyyyMMdd");
        String accountingPeriod = String.format("%02d", month);
        log.info("----> \u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e187\u548c121 ds[{}] accountingPeriod[{}] start <----", (Object)ds, (Object)accountingPeriod);
        this.pullFeePoolDataService.pullFeePoolData(ds, accountingPeriod);
        log.info("----> \u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e187\u548c121 ds[{}] accountingPeriod[{}] end <----", (Object)ds, (Object)accountingPeriod);
    }
}

